/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.HashMap;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpAuthenticator;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHttpAuthenticator {
    private AuthenticationStrategy authStrategy;
    private AuthState authState;
    private AuthScheme authScheme;
    private HttpContext context;
    private HttpHost host;
    private HttpHost proxy;
    private Credentials credentials;
    private BasicCredentialsProvider credentialsProvider;
    private AuthSchemeRegistry authSchemeRegistry;
    private AuthCache authCache;
    private HttpAuthenticator httpAuthenticator;

    @Before
    public void setUp() throws Exception {
        this.authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        this.authState = new AuthState();
        this.authScheme = new BasicScheme();
        this.authScheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", "Basic realm=test"));
        this.context = new BasicHttpContext();
        this.host = new HttpHost("localhost", 80);
        this.proxy = new HttpHost("localhost", 8888);
        this.context.setAttribute("http.target_host", (Object)this.host);
        this.context.setAttribute("http.proxy_host", (Object)this.proxy);
        this.credentials = (Credentials)Mockito.mock(Credentials.class);
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, this.credentials);
        this.context.setAttribute("http.auth.credentials-provider", (Object)this.credentialsProvider);
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("basic", (AuthSchemeFactory)new BasicSchemeFactory());
        this.authSchemeRegistry.register("digest", (AuthSchemeFactory)new DigestSchemeFactory());
        this.authSchemeRegistry.register("ntlm", (AuthSchemeFactory)new NTLMSchemeFactory());
        this.context.setAttribute("http.authscheme-registry", (Object)this.authSchemeRegistry);
        this.authCache = (AuthCache)Mockito.mock(AuthCache.class);
        this.context.setAttribute("http.auth.auth-cache", (Object)this.authCache);
        this.httpAuthenticator = new HttpAuthenticator();
    }

    @Test
    public void testAuthenticationRequested() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.TRUE);
        Assert.assertTrue((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
    }

    @Test
    public void testAuthenticationNotRequestedUnchallenged() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.FALSE);
        Assert.assertFalse((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.UNCHALLENGED, (Object)this.authState.getState());
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
    }

    @Test
    public void testAuthenticationNotRequestedSuccess1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.FALSE);
        this.authState.update(this.authScheme, this.credentials);
        this.authState.setState(AuthProtocolState.CHALLENGED);
        Assert.assertFalse((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.SUCCESS, (Object)this.authState.getState());
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).authSucceeded(this.host, this.authScheme, this.context);
    }

    @Test
    public void testAuthenticationNotRequestedSuccess2() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.FALSE);
        this.authState.update(this.authScheme, this.credentials);
        this.authState.setState(AuthProtocolState.HANDSHAKE);
        Assert.assertFalse((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.SUCCESS, (Object)this.authState.getState());
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).authSucceeded(this.host, this.authScheme, this.context);
    }

    @Test
    public void testAuthentication() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertTrue((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.CHALLENGED, (Object)this.authState.getState());
        Queue options = this.authState.getAuthOptions();
        Assert.assertNotNull((Object)options);
        AuthOption option1 = (AuthOption)options.poll();
        Assert.assertNotNull((Object)option1);
        Assert.assertEquals((Object)"digest", (Object)option1.getAuthScheme().getSchemeName());
        AuthOption option2 = (AuthOption)options.poll();
        Assert.assertNotNull((Object)option2);
        Assert.assertEquals((Object)"basic", (Object)option2.getAuthScheme().getSchemeName());
        Assert.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationNoChallenges() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        Mockito.when((Object)this.authStrategy.getChallenges((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn(new HashMap());
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
    }

    @Test
    public void testAuthenticationNoSupportedChallenges() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "This realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "That realm=\"realm1\", nonce=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
    }

    @Test
    public void testAuthenticationNoCredentials() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        this.credentialsProvider.clear();
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
    }

    @Test
    public void testAuthenticationFailed() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        this.authState.setState(AuthProtocolState.FAILURE);
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.FAILURE, (Object)this.authState.getState());
    }

    @Test
    public void testAuthenticationNoAuthScheme() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update(this.authScheme, this.credentials);
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.FAILURE, (Object)this.authState.getState());
        ((AuthCache)Mockito.verify((Object)this.authCache)).remove(host);
    }

    @Test
    public void testAuthenticationFailure() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)new BasicScheme(), this.credentials);
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.FAILURE, (Object)this.authState.getState());
        Assert.assertNull((Object)this.authState.getCredentials());
    }

    @Test
    public void testAuthenticationHandshaking() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", stale=true, nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)new DigestScheme(), this.credentials);
        Assert.assertTrue((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.HANDSHAKE, (Object)this.authState.getState());
    }

    @Test
    public void testAuthenticationNoMatchingChallenge() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)new BasicScheme(), this.credentials);
        Assert.assertTrue((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.CHALLENGED, (Object)this.authState.getState());
        Queue options = this.authState.getAuthOptions();
        Assert.assertNotNull((Object)options);
        AuthOption option1 = (AuthOption)options.poll();
        Assert.assertNotNull((Object)option1);
        Assert.assertEquals((Object)"digest", (Object)option1.getAuthScheme().getSchemeName());
        Assert.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationException() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        ((AuthenticationStrategy)Mockito.doThrow((Throwable)new MalformedChallengeException()).when((Object)this.authStrategy)).getChallenges((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class));
        Assert.assertFalse((boolean)this.httpAuthenticator.authenticate(host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.UNCHALLENGED, (Object)this.authState.getState());
        Assert.assertNull((Object)this.authState.getAuthScheme());
        Assert.assertNull((Object)this.authState.getCredentials());
    }
}

