/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpHost;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.AwaitThread;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class TestWaitingThread {
    public static final HttpHost TARGET = new HttpHost("target.test.invalid");

    @Test
    public void testConstructor() {
        try {
            new WaitingThread(null, null);
            Assert.fail((String)"null condition not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        ReentrantLock lck = new ReentrantLock();
        Condition cnd = lck.newCondition();
        WaitingThread wt = new WaitingThread(cnd, null);
        Assert.assertEquals((String)"wrong condition", (Object)cnd, (Object)wt.getCondition());
        Assert.assertNull((String)"pool from nowhere", (Object)wt.getPool());
        Assert.assertNull((String)"thread from nowhere", (Object)wt.getThread());
        HttpRoute route = new HttpRoute(TARGET);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(10);
        RouteSpecificPool rospl = new RouteSpecificPool(route, (ConnPerRoute)connPerRoute);
        wt = new WaitingThread(cnd, rospl);
        Assert.assertEquals((String)"wrong condition", (Object)cnd, (Object)wt.getCondition());
        Assert.assertEquals((String)"wrong pool", (Object)rospl, (Object)wt.getPool());
        Assert.assertNull((String)"thread from nowhere", (Object)wt.getThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAwaitWakeup() throws InterruptedException {
        ReentrantLock lck = new ReentrantLock();
        Condition cnd = lck.newCondition();
        WaitingThread wt = new WaitingThread(cnd, null);
        AwaitThread ath = new AwaitThread(wt, lck, null);
        ath.start();
        Thread.sleep(100L);
        Assert.assertNull((String)"thread caught exception", (Object)ath.getException());
        Assert.assertTrue((String)"thread not waiting", (boolean)ath.isWaiting());
        Assert.assertEquals((String)"wrong thread", (Object)ath, (Object)wt.getThread());
        Thread.sleep(500L);
        Assert.assertTrue((String)"thread not waiting, spurious wakeup?", (boolean)ath.isWaiting());
        try {
            lck.lock();
            wt.wakeup();
        }
        finally {
            lck.unlock();
        }
        ath.join(10000L);
        Assert.assertFalse((String)"thread still waiting", (boolean)ath.isWaiting());
        Assert.assertNull((String)"thread caught exception", (Object)ath.getException());
        Assert.assertNull((String)"thread still there", (Object)wt.getThread());
    }

    @Test
    public void testInterrupt() throws InterruptedException {
        ReentrantLock lck = new ReentrantLock();
        Condition cnd = lck.newCondition();
        WaitingThread wt = new WaitingThread(cnd, null);
        AwaitThread ath = new AwaitThread(wt, lck, null);
        ath.start();
        Thread.sleep(100L);
        Assert.assertNull((String)"thread caught exception", (Object)ath.getException());
        Assert.assertTrue((String)"thread not waiting", (boolean)ath.isWaiting());
        Assert.assertEquals((String)"wrong thread", (Object)ath, (Object)wt.getThread());
        ath.interrupt();
        Thread.sleep(100L);
        Assert.assertFalse((String)"thread still waiting", (boolean)ath.isWaiting());
        Assert.assertNotNull((String)"thread didn't catch exception", (Object)ath.getException());
        Assert.assertTrue((String)"thread caught wrong exception", (boolean)(ath.getException() instanceof InterruptedException));
        Assert.assertNull((String)"thread still there", (Object)wt.getThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegal() throws InterruptedException {
        ReentrantLock lck = new ReentrantLock();
        Condition cnd = lck.newCondition();
        WaitingThread wt = new WaitingThread(cnd, null);
        try {
            lck.lock();
            wt.wakeup();
            Assert.fail((String)"missing waiter not detected");
        }
        catch (IllegalStateException isx) {
        }
        finally {
            lck.unlock();
        }
        AwaitThread ath1 = new AwaitThread(wt, lck, null);
        ath1.start();
        Thread.sleep(100L);
        Assert.assertNull((String)"thread caught exception", (Object)ath1.getException());
        Assert.assertTrue((String)"thread not waiting", (boolean)ath1.isWaiting());
        Assert.assertEquals((String)"wrong thread", (Object)ath1, (Object)wt.getThread());
        AwaitThread ath2 = new AwaitThread(wt, lck, null);
        ath2.start();
        Thread.sleep(100L);
        Assert.assertFalse((String)"thread waiting", (boolean)ath2.isWaiting());
        Assert.assertNotNull((String)"thread didn't catch exception", (Object)ath2.getException());
        Assert.assertTrue((String)"thread caught wrong exception", (boolean)(ath2.getException() instanceof IllegalStateException));
        ath1.interrupt();
        ath2.interrupt();
    }
}

