/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Calendar;
import java.util.Date;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtils {
    @Test
    public void testBasicDateParse() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(2005, 9, 14, 0, 0, 0);
        calendar.set(14, 0);
        Date date1 = calendar.getTime();
        String[] formats = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"};
        Date date2 = DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (String[])formats, null);
        Assert.assertEquals((Object)date1, (Object)date2);
        date2 = DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (String[])formats);
        Assert.assertEquals((Object)date1, (Object)date2);
        date2 = DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT");
        Assert.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testInvalidInput() throws Exception {
        try {
            DateUtils.parseDate(null, null, null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (String[])new String[0], null);
            Assert.fail((String)"DateParseException should habe been thrown");
        }
        catch (DateParseException ex) {
            // empty catch block
        }
        try {
            DateUtils.formatDate(null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            DateUtils.formatDate((Date)new Date(), null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoDigitYearDateParse() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(2005, 9, 14, 0, 0, 0);
        calendar.set(14, 0);
        Date date1 = calendar.getTime();
        String[] formats = new String[]{"EEE, dd-MMM-yy HH:mm:ss zzz"};
        Date date2 = DateUtils.parseDate((String)"Friday, 14-Oct-05 00:00:00 GMT", (String[])formats, null);
        Assert.assertEquals((Object)date1, (Object)date2);
        calendar.set(1900, 0, 0, 0, 0, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.set(1905, 9, 14, 0, 0, 0);
        calendar.set(14, 0);
        date1 = calendar.getTime();
        date2 = DateUtils.parseDate((String)"Friday, 14-Oct-05 00:00:00 GMT", (String[])formats, (Date)startDate);
        Assert.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testParseQuotedDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(2005, 9, 14, 0, 0, 0);
        calendar.set(14, 0);
        Date date1 = calendar.getTime();
        String[] formats = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"};
        Date date2 = DateUtils.parseDate((String)"'Fri, 14 Oct 2005 00:00:00 GMT'", (String[])formats);
        Assert.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testBasicDateFormat() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(2005, 9, 14, 0, 0, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        Assert.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatDate((Date)date));
        Assert.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatDate((Date)date, (String)"EEE, dd MMM yyyy HH:mm:ss zzz"));
    }

    @Test
    public void testConstructor() {
        new DateParseException();
        new DateParseException("Oppsie");
    }
}

