/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.mockup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.impl.io.AbstractSessionInputBuffer;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class SessionInputBufferMockup
extends AbstractSessionInputBuffer {
    public static final int BUFFER_SIZE = 16;

    public SessionInputBufferMockup(InputStream instream, int buffersize, HttpParams params) {
        this.init(instream, buffersize, params);
    }

    public SessionInputBufferMockup(InputStream instream, int buffersize) {
        this(instream, buffersize, (HttpParams)new BasicHttpParams());
    }

    public SessionInputBufferMockup(byte[] bytes, HttpParams params) {
        this(bytes, 16, params);
    }

    public SessionInputBufferMockup(byte[] bytes) {
        this(bytes, 16, (HttpParams)new BasicHttpParams());
    }

    public SessionInputBufferMockup(byte[] bytes, int buffersize, HttpParams params) {
        this(new ByteArrayInputStream(bytes), buffersize, params);
    }

    public SessionInputBufferMockup(byte[] bytes, int buffersize) {
        this(new ByteArrayInputStream(bytes), buffersize, (HttpParams)new BasicHttpParams());
    }

    public SessionInputBufferMockup(String s, String charset, int buffersize, HttpParams params) throws UnsupportedEncodingException {
        this(s.getBytes(charset), buffersize, params);
    }

    public SessionInputBufferMockup(String s, String charset, int buffersize) throws UnsupportedEncodingException {
        this(s.getBytes(charset), buffersize, (HttpParams)new BasicHttpParams());
    }

    public SessionInputBufferMockup(String s, String charset, HttpParams params) throws UnsupportedEncodingException {
        this(s.getBytes(charset), params);
    }

    public SessionInputBufferMockup(String s, String charset) throws UnsupportedEncodingException {
        this(s.getBytes(charset), (HttpParams)new BasicHttpParams());
    }

    public boolean isDataAvailable(int timeout) throws IOException {
        return true;
    }
}

