/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.LangUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpRequestBase {
    @Test
    public void testBasicProperties() throws Exception {
        HttpGet httpget = new HttpGet("http://host/path");
        httpget.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        Assert.assertEquals((Object)"GET", (Object)httpget.getRequestLine().getMethod());
        Assert.assertEquals((Object)"http://host/path", (Object)httpget.getRequestLine().getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)httpget.getRequestLine().getProtocolVersion());
    }

    @Test
    public void testEmptyURI() throws Exception {
        HttpGet httpget = new HttpGet("");
        Assert.assertEquals((Object)"/", (Object)httpget.getRequestLine().getUri());
    }

    @Test
    public void testCloneBasicRequests() throws Exception {
        HttpGet httpget = new HttpGet("http://host/path");
        httpget.addHeader("h1", "this header");
        httpget.addHeader("h2", "that header");
        httpget.addHeader("h3", "all sorts of headers");
        httpget.getParams().setParameter("p1", (Object)1);
        httpget.getParams().setParameter("p2", (Object)"whatever");
        HttpGet clone = (HttpGet)httpget.clone();
        Assert.assertEquals((Object)httpget.getMethod(), (Object)clone.getMethod());
        Assert.assertEquals((Object)httpget.getURI(), (Object)clone.getURI());
        Object[] headers1 = httpget.getAllHeaders();
        Object[] headers2 = clone.getAllHeaders();
        Assert.assertTrue((boolean)LangUtils.equals((Object[])headers1, (Object[])headers2));
        Assert.assertTrue((httpget.getParams() != clone.getParams() ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)clone.getParams().getParameter("p1"));
        Assert.assertEquals((Object)"whatever", (Object)clone.getParams().getParameter("p2"));
        Assert.assertEquals(null, (Object)clone.getParams().getParameter("p3"));
    }

    @Test
    public void testCloneEntityEnclosingRequests() throws Exception {
        HttpPost httppost = new HttpPost("http://host/path");
        httppost.addHeader("h1", "this header");
        httppost.addHeader("h2", "that header");
        httppost.addHeader("h3", "all sorts of headers");
        httppost.getParams().setParameter("p1", (Object)1);
        httppost.getParams().setParameter("p2", (Object)"whatever");
        HttpPost clone = (HttpPost)httppost.clone();
        Assert.assertEquals((Object)httppost.getMethod(), (Object)clone.getMethod());
        Assert.assertEquals((Object)httppost.getURI(), (Object)clone.getURI());
        Object[] headers1 = httppost.getAllHeaders();
        Object[] headers2 = clone.getAllHeaders();
        Assert.assertTrue((boolean)LangUtils.equals((Object[])headers1, (Object[])headers2));
        Assert.assertTrue((httppost.getParams() != clone.getParams() ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)clone.getParams().getParameter("p1"));
        Assert.assertEquals((Object)"whatever", (Object)clone.getParams().getParameter("p2"));
        Assert.assertEquals(null, (Object)clone.getParams().getParameter("p3"));
        Assert.assertNull((Object)clone.getEntity());
        StringEntity e1 = new StringEntity("stuff");
        httppost.setEntity((HttpEntity)e1);
        clone = (HttpPost)httppost.clone();
        Assert.assertTrue((boolean)(clone.getEntity() instanceof StringEntity));
        Assert.assertFalse((boolean)clone.getEntity().equals(e1));
    }

    @Test(expected=CloneNotSupportedException.class)
    public void testCloneStreamingEntityEnclosingRequests() throws Exception {
        ByteArrayInputStream instream = new ByteArrayInputStream(new byte[0]);
        InputStreamEntity e2 = new InputStreamEntity((InputStream)instream, -1L);
        HttpPost httppost = new HttpPost("http://host/path");
        httppost.setEntity((HttpEntity)e2);
        httppost.clone();
    }
}

