/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRedirects
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        this.httpclient = new DefaultHttpClient();
    }

    @Test
    public void testBasicRedirect300() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 300));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)300L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testBasicRedirect301() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 301));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test
    public void testBasicRedirect302() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 302));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test
    public void testBasicRedirect302NoLocation() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(302);
            }
        });
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)302L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test
    public void testBasicRedirect303() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 303));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test
    public void testBasicRedirect304() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 304));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)304L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testBasicRedirect305() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 305));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)305L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testBasicRedirect307() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 307));
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test(expected=ClientProtocolException.class)
    public void testMaxRedirectCheck() throws Exception {
        this.localServer.register("*", new CircularRedirectService());
        this.httpclient.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        this.httpclient.getParams().setIntParameter("http.protocol.max-redirects", 5);
        HttpGet httpget = new HttpGet("/circular-oldlocation/");
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RedirectException));
            throw e;
        }
    }

    @Test(expected=ClientProtocolException.class)
    public void testCircularRedirect() throws Exception {
        this.localServer.register("*", new CircularRedirectService());
        this.httpclient.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", false);
        HttpGet httpget = new HttpGet("/circular-oldlocation/");
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof CircularRedirectException));
            throw e;
        }
    }

    @Test
    public void testPostNoRedirect() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port));
        BasicHttpContext context = new BasicHttpContext();
        HttpPost httppost = new HttpPost("/oldlocation/");
        httppost.setEntity((HttpEntity)new StringEntity("stuff"));
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httppost, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)302L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)"POST", (Object)reqWrapper.getRequestLine().getMethod());
    }

    @Test
    public void testPostRedirectSeeOther() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port, 303));
        BasicHttpContext context = new BasicHttpContext();
        HttpPost httppost = new HttpPost("/oldlocation/");
        httppost.setEntity((HttpEntity)new StringEntity("stuff"));
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httppost, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)"GET", (Object)reqWrapper.getRequestLine().getMethod());
    }

    @Test
    public void testRelativeRedirect() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new RelativeRedirectService());
        BasicHttpContext context = new BasicHttpContext();
        this.httpclient.getParams().setBooleanParameter("http.protocol.reject-relative-redirect", false);
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/relativelocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test
    public void testRelativeRedirect2() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new RelativeRedirectService2());
        BasicHttpContext context = new BasicHttpContext();
        this.httpclient.getParams().setBooleanParameter("http.protocol.reject-relative-redirect", false);
        HttpGet httpget = new HttpGet("/test/oldlocation");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/test/relativelocation", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)targetHost.getHostName());
        Assert.assertEquals((long)port, (long)targetHost.getPort());
    }

    @Test(expected=ClientProtocolException.class)
    public void testRejectRelativeRedirect() throws Exception {
        this.localServer.register("*", new RelativeRedirectService());
        this.httpclient.getParams().setBooleanParameter("http.protocol.reject-relative-redirect", true);
        HttpGet httpget = new HttpGet("/oldlocation/");
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProtocolException));
            throw e;
        }
    }

    @Test(expected=ClientProtocolException.class)
    public void testRejectBogusRedirectLocation() throws Exception {
        this.localServer.register("*", new BogusRedirectService("xxx://bogus"));
        HttpGet httpget = new HttpGet("/oldlocation/");
        this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
    }

    @Test(expected=ClientProtocolException.class)
    public void testRejectInvalidRedirectLocation() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BogusRedirectService("http://" + host + ":" + port + "/newlocation/?p=I have spaces"));
        HttpGet httpget = new HttpGet("/oldlocation/");
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProtocolException));
            throw e;
        }
    }

    @Test
    public void testRedirectWithCookie() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port));
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.httpclient.setCookieStore((CookieStore)cookieStore);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(host);
        cookie.setPath("/");
        cookieStore.addCookie((Cookie)cookie);
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Header[] headers = reqWrapper.getHeaders("Cookie");
        Assert.assertEquals((String)"There can only be one (cookie)", (long)1L, (long)headers.length);
    }

    @Test
    public void testDefaultHeadersRedirect() throws Exception {
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        this.localServer.register("*", new BasicRedirectService(host, port));
        BasicHttpContext context = new BasicHttpContext();
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>(1);
        defaultHeaders.add(new BasicHeader("User-Agent", "my-test-client"));
        this.httpclient.getParams().setParameter("http.default-headers", defaultHeaders);
        HttpGet httpget = new HttpGet("/oldlocation/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Header header = reqWrapper.getFirstHeader("User-Agent");
        Assert.assertEquals((Object)"my-test-client", (Object)header.getValue());
    }

    private static class BogusRedirectService
    implements HttpRequestHandler {
        private String url;

        public BogusRedirectService(String redirectUrl) {
            this.url = redirectUrl;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/oldlocation/")) {
                response.setStatusLine(ver, 302);
                response.addHeader((Header)new BasicHeader("Location", this.url));
            } else if (uri.equals("/relativelocation/")) {
                response.setStatusLine(ver, 200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusLine(ver, 404);
            }
        }
    }

    private static class RelativeRedirectService2
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/test/oldlocation")) {
                response.setStatusLine(ver, 302);
                response.addHeader((Header)new BasicHeader("Location", "relativelocation"));
            } else if (uri.equals("/test/relativelocation")) {
                response.setStatusLine(ver, 200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusLine(ver, 404);
            }
        }
    }

    private static class RelativeRedirectService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/oldlocation/")) {
                response.setStatusLine(ver, 302);
                response.addHeader((Header)new BasicHeader("Location", "/relativelocation/"));
            } else if (uri.equals("/relativelocation/")) {
                response.setStatusLine(ver, 200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusLine(ver, 404);
            }
        }
    }

    private static class CircularRedirectService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            String uri = request.getRequestLine().getUri();
            if (uri.startsWith("/circular-oldlocation")) {
                response.setStatusLine(ver, 302);
                response.addHeader((Header)new BasicHeader("Location", "/circular-location2"));
            } else if (uri.startsWith("/circular-location2")) {
                response.setStatusLine(ver, 302);
                response.addHeader((Header)new BasicHeader("Location", "/circular-oldlocation"));
            } else {
                response.setStatusLine(ver, 404);
            }
        }
    }

    private static class BasicRedirectService
    implements HttpRequestHandler {
        private int statuscode = 302;
        private String host = null;
        private int port;

        public BasicRedirectService(String host, int port, int statuscode) {
            this.host = host;
            this.port = port;
            if (statuscode > 0) {
                this.statuscode = statuscode;
            }
        }

        public BasicRedirectService(String host, int port) {
            this(host, port, -1);
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/oldlocation/")) {
                response.setStatusLine(ver, this.statuscode);
                response.addHeader((Header)new BasicHeader("Location", "http://" + this.host + ":" + this.port + "/newlocation/"));
                response.addHeader((Header)new BasicHeader("Connection", "close"));
            } else if (uri.equals("/newlocation/")) {
                response.setStatusLine(ver, 200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusLine(ver, 404);
            }
        }
    }
}

