/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.util.LinkedList;
import junit.framework.Assert;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.client.protocol.RequestAuthenticationBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRequestAuthenticationBase {
    private ContextAwareAuthScheme authScheme;
    private Credentials credentials;
    private AuthState authState;
    private HttpContext context;
    private HttpRequestInterceptor interceptor;

    @Before
    public void setUp() throws Exception {
        this.authScheme = (ContextAwareAuthScheme)Mockito.mock(ContextAwareAuthScheme.class);
        this.credentials = (Credentials)Mockito.mock(Credentials.class);
        this.authState = new AuthState();
        this.context = new BasicHttpContext();
        this.context.setAttribute("test-auth-state", (Object)this.authState);
        this.interceptor = new TestRequestAuthentication();
    }

    @Test
    public void testAuthFailureState() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.FAILURE);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        this.interceptor.process((HttpRequest)request, this.context);
        Assert.assertFalse((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme, (VerificationMode)Mockito.never())).authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
    }

    @Test
    public void testAuthChallengeStateNoOption() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.interceptor.process((HttpRequest)request, this.context);
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme)).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthChallengeStateOneOptions() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        LinkedList<AuthOption> authOptions = new LinkedList<AuthOption>();
        authOptions.add(new AuthOption((AuthScheme)this.authScheme, this.credentials));
        this.authState.update(authOptions);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.interceptor.process((HttpRequest)request, this.context);
        Assert.assertSame((Object)this.authScheme, (Object)this.authState.getAuthScheme());
        Assert.assertSame((Object)this.credentials, (Object)this.authState.getCredentials());
        Assert.assertNull((Object)this.authState.getAuthOptions());
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme)).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthChallengeStateMultipleOption() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        LinkedList<AuthOption> authOptions = new LinkedList<AuthOption>();
        ContextAwareAuthScheme authScheme1 = (ContextAwareAuthScheme)Mockito.mock(ContextAwareAuthScheme.class);
        ((ContextAwareAuthScheme)Mockito.doThrow((Throwable)new AuthenticationException()).when((Object)authScheme1)).authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
        ContextAwareAuthScheme authScheme2 = (ContextAwareAuthScheme)Mockito.mock(ContextAwareAuthScheme.class);
        Mockito.when((Object)authScheme2.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        authOptions.add(new AuthOption((AuthScheme)authScheme1, this.credentials));
        authOptions.add(new AuthOption((AuthScheme)authScheme2, this.credentials));
        this.authState.update(authOptions);
        this.interceptor.process((HttpRequest)request, this.context);
        Assert.assertSame((Object)authScheme2, (Object)this.authState.getAuthScheme());
        Assert.assertSame((Object)this.credentials, (Object)this.authState.getCredentials());
        Assert.assertNull((Object)this.authState.getAuthOptions());
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)authScheme1, (VerificationMode)Mockito.times((int)1))).authenticate(this.credentials, (HttpRequest)request, this.context);
        ((ContextAwareAuthScheme)Mockito.verify((Object)authScheme2, (VerificationMode)Mockito.times((int)1))).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthSuccess() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.SUCCESS);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        Mockito.when((Object)this.authScheme.isConnectionBased()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.interceptor.process((HttpRequest)request, this.context);
        Assert.assertSame((Object)this.authScheme, (Object)this.authState.getAuthScheme());
        Assert.assertSame((Object)this.credentials, (Object)this.authState.getCredentials());
        Assert.assertNull((Object)this.authState.getAuthOptions());
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme)).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthSuccessConnectionBased() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.SUCCESS);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        Mockito.when((Object)this.authScheme.isConnectionBased()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.interceptor.process((HttpRequest)request, this.context);
        Assert.assertFalse((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme, (VerificationMode)Mockito.never())).authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
    }

    static class TestRequestAuthentication
    extends RequestAuthenticationBase {
        TestRequestAuthentication() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("test-auth-state");
            super.process(authState, request, context);
        }
    }
}

