/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConnectionAutoRelease
extends ServerTestBase {
    @Test
    public void testReleaseOnEntityConsumeContent() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setDefaultMaxPerRoute(1);
        mgr.setMaxTotal(1);
        PoolStats stats = mgr.getTotalStats();
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr);
        HttpGet httpget = new HttpGet("/random/20000");
        HttpHost target = this.getServerHttp();
        HttpResponse response = client.execute(target, (HttpRequest)httpget);
        ClientConnectionRequest connreq = mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.getConnection(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        EntityUtils.consume((HttpEntity)e);
        stats = mgr.getTotalStats();
        Assert.assertEquals((long)1L, (long)stats.getAvailable());
        connreq = mgr.requestConnection(new HttpRoute(target), null);
        ManagedClientConnection conn = connreq.getConnection(250L, TimeUnit.MILLISECONDS);
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testReleaseOnEntityWriteTo() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setDefaultMaxPerRoute(1);
        mgr.setMaxTotal(1);
        PoolStats stats = mgr.getTotalStats();
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr);
        HttpGet httpget = new HttpGet("/random/20000");
        HttpHost target = this.getServerHttp();
        HttpResponse response = client.execute(target, (HttpRequest)httpget);
        ClientConnectionRequest connreq = mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.getConnection(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        ByteArrayOutputStream outsteam = new ByteArrayOutputStream();
        e.writeTo((OutputStream)outsteam);
        stats = mgr.getTotalStats();
        Assert.assertEquals((long)1L, (long)stats.getAvailable());
        connreq = mgr.requestConnection(new HttpRoute(target), null);
        ManagedClientConnection conn = connreq.getConnection(250L, TimeUnit.MILLISECONDS);
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testReleaseOnAbort() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setDefaultMaxPerRoute(1);
        mgr.setMaxTotal(1);
        PoolStats stats = mgr.getTotalStats();
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr);
        HttpGet httpget = new HttpGet("/random/20000");
        HttpHost target = this.getServerHttp();
        HttpResponse response = client.execute(target, (HttpRequest)httpget);
        ClientConnectionRequest connreq = mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.getConnection(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        httpget.abort();
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        connreq = mgr.requestConnection(new HttpRoute(target), null);
        ManagedClientConnection conn = connreq.getConnection(250L, TimeUnit.MILLISECONDS);
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testReleaseOnIOException() throws Exception {
        this.localServer.register("/dropdead", new HttpRequestHandler(){

            public void handle(HttpRequest request, final HttpResponse response, final HttpContext context) throws HttpException, IOException {
                BasicHttpEntity entity = new BasicHttpEntity(){

                    public void writeTo(OutputStream outstream) throws IOException {
                        byte[] tmp = new byte[5];
                        outstream.write(tmp);
                        outstream.flush();
                        DefaultHttpServerConnection conn = (DefaultHttpServerConnection)context.getAttribute("http.connection");
                        try {
                            conn.sendResponseHeader(response);
                        }
                        catch (HttpException ignore) {
                            // empty catch block
                        }
                    }
                };
                entity.setChunked(true);
                response.setEntity((HttpEntity)entity);
            }
        });
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setDefaultMaxPerRoute(1);
        mgr.setMaxTotal(1);
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr);
        HttpGet httpget = new HttpGet("/dropdead");
        HttpHost target = this.getServerHttp();
        HttpResponse response = client.execute(target, (HttpRequest)httpget);
        ClientConnectionRequest connreq = mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.getConnection(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        try {
            EntityUtils.toByteArray((HttpEntity)e);
            Assert.fail((String)"MalformedChunkCodingException should have been thrown");
        }
        catch (MalformedChunkCodingException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        connreq = mgr.requestConnection(new HttpRoute(target), null);
        ManagedClientConnection conn = connreq.getConnection(250L, TimeUnit.MILLISECONDS);
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }
}

