/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBasicAuthCache {
    @Test
    public void testBasics() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        AuthScheme authScheme = (AuthScheme)Mockito.mock(AuthScheme.class);
        cache.put(new HttpHost("localhost", 80), authScheme);
        Assert.assertSame((Object)authScheme, (Object)cache.get(new HttpHost("localhost", 80)));
        cache.remove(new HttpHost("localhost", 80));
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.put(new HttpHost("localhost", 80), authScheme);
        cache.clear();
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    @Test
    public void testGetKey() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        HttpHost target = new HttpHost("localhost", 443, "https");
        Assert.assertSame((Object)target, (Object)cache.getKey(target));
        Assert.assertEquals((Object)target, (Object)cache.getKey(new HttpHost("localhost", -1, "https")));
    }
}

