/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.InputStream;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicStatusLine;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBasicResponseHandler {
    @Test
    public void testSuccessfulResponse() throws Exception {
        BasicStatusLine sl = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        StringEntity entity = new StringEntity("stuff");
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicResponseHandler handler = new BasicResponseHandler();
        String s = handler.handleResponse(response);
        Assert.assertEquals((String)"stuff", (String)s);
    }

    @Test
    public void testUnsuccessfulResponse() throws Exception {
        InputStream instream = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)instream);
        BasicStatusLine sl = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 404, "Not Found");
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicResponseHandler handler = new BasicResponseHandler();
        try {
            handler.handleResponse(response);
            Assert.fail((String)"HttpResponseException expected");
        }
        catch (HttpResponseException ex) {
            Assert.assertEquals((int)404, (int)ex.getStatusCode());
            Assert.assertEquals((String)"Not Found", (String)ex.getMessage());
        }
        ((HttpEntity)Mockito.verify((Object)entity)).getContent();
        ((InputStream)Mockito.verify((Object)instream)).close();
    }
}

