/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.localserver.RequestBasicAuth;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClientReauthentication
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestBasicAuth());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseBasicUnauthorized());
        this.localServer = new LocalTestServer(httpproc, null);
        this.httpclient = new DefaultHttpClient();
    }

    @Test
    public void testBasicAuthenticationSuccess() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        this.httpclient.getAuthSchemes().register("MyBasic", (AuthSchemeFactory)new BasicSchemeFactory(){

            public AuthScheme newInstance(HttpParams params) {
                return new BasicScheme(){

                    public String getSchemeName() {
                        return "MyBasic";
                    }
                };
            }
        });
        this.httpclient.setTargetAuthenticationStrategy((AuthenticationStrategy)new TargetAuthenticationStrategy(){

            protected boolean isCachable(AuthScheme authScheme) {
                return "MyBasic".equalsIgnoreCase(authScheme.getSchemeName());
            }
        });
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        this.httpclient.getParams().setParameter("http.auth.target-scheme-pref", Collections.singletonList("MyBasic"));
        BasicHttpContext context = new BasicHttpContext();
        for (int i = 0; i < 10; ++i) {
            HttpGet httpget = new HttpGet("/");
            HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
            HttpEntity entity = response.getEntity();
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertNotNull((Object)entity);
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    static class TestCredentialsProvider
    implements CredentialsProvider {
        private final Credentials creds;
        private AuthScope authscope;

        TestCredentialsProvider(Credentials creds) {
            this.creds = creds;
        }

        public void clear() {
        }

        public Credentials getCredentials(AuthScope authscope) {
            this.authscope = authscope;
            return this.creds;
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
        }

        public AuthScope getAuthScope() {
            return this.authscope;
        }
    }

    static class AuthHandler
    implements HttpRequestHandler {
        private AtomicLong count = new AtomicLong(0L);

        AuthHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String creds = (String)context.getAttribute("creds");
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(401);
            } else if (this.count.incrementAndGet() % 4L == 0L) {
                response.setStatusCode(401);
            } else {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("success", Consts.ASCII);
                response.setEntity((HttpEntity)entity);
            }
        }
    }

    public class ResponseBasicUnauthorized
    implements HttpResponseInterceptor {
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (response.getStatusLine().getStatusCode() == 401) {
                response.addHeader("WWW-Authenticate", "MyBasic realm=\"test realm\"");
            }
        }
    }
}

