/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DummyHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestDecompressingHttpClient {
    private DummyHttpClient backend;
    @Mock
    private ClientConnectionManager mockConnManager;
    @Mock
    private ResponseHandler<Object> mockHandler;
    private DecompressingHttpClient impl;
    private HttpUriRequest request;
    private HttpContext ctx;
    private HttpHost host;
    @Mock
    private HttpResponse mockResponse;
    @Mock
    private HttpEntity mockEntity;
    private Object handled;

    @Before
    public void canCreate() {
        this.handled = new Object();
        this.backend = new DummyHttpClient();
        this.impl = new DecompressingHttpClient((HttpClient)this.backend);
        this.request = new HttpGet("http://localhost:8080");
        this.ctx = new BasicHttpContext();
        this.host = new HttpHost("www.example.com");
    }

    @Test
    public void isAnHttpClient() {
        Assert.assertTrue((boolean)(this.impl instanceof HttpClient));
    }

    @Test
    public void usesParamsFromBackend() {
        BasicHttpParams params = new BasicHttpParams();
        this.backend.setParams((HttpParams)params);
        Assert.assertSame((Object)params, (Object)this.impl.getParams());
    }

    @Test
    public void extractsHostNameFromUriRequest() {
        Assert.assertEquals((Object)new HttpHost("www.example.com"), (Object)this.impl.getHttpHost((HttpUriRequest)new HttpGet("http://www.example.com/")));
    }

    @Test
    public void extractsHostNameAndPortFromUriRequest() {
        Assert.assertEquals((Object)new HttpHost("www.example.com", 8080), (Object)this.impl.getHttpHost((HttpUriRequest)new HttpGet("http://www.example.com:8080/")));
    }

    @Test
    public void extractsIPAddressFromUriRequest() {
        Assert.assertEquals((Object)new HttpHost("10.0.0.1"), (Object)this.impl.getHttpHost((HttpUriRequest)new HttpGet("http://10.0.0.1/")));
    }

    @Test
    public void extractsIPAddressAndPortFromUriRequest() {
        Assert.assertEquals((Object)new HttpHost("10.0.0.1", 8080), (Object)this.impl.getHttpHost((HttpUriRequest)new HttpGet("http://10.0.0.1:8080/")));
    }

    @Test
    public void extractsLocalhostFromUriRequest() {
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)this.impl.getHttpHost((HttpUriRequest)new HttpGet("http://localhost/")));
    }

    @Test
    public void extractsLocalhostAndPortFromUriRequest() {
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)this.impl.getHttpHost((HttpUriRequest)new HttpGet("http://localhost:8080/")));
    }

    @Test
    public void usesConnectionManagerFromBackend() {
        this.backend.setConnectionManager(this.mockConnManager);
        Assert.assertSame((Object)this.mockConnManager, (Object)this.impl.getConnectionManager());
    }

    private void assertAcceptEncodingGzipAndDeflateWereAddedToRequest(HttpRequest captured) {
        boolean foundGzip = false;
        boolean foundDeflate = false;
        for (Header h : captured.getHeaders("Accept-Encoding")) {
            for (HeaderElement elt : h.getElements()) {
                if ("gzip".equals(elt.getName())) {
                    foundGzip = true;
                }
                if (!"deflate".equals(elt.getName())) continue;
                foundDeflate = true;
            }
        }
        Assert.assertTrue((boolean)foundGzip);
        Assert.assertTrue((boolean)foundDeflate);
    }

    @Test
    public void addsAcceptEncodingHeaderToHttpUriRequest() throws Exception {
        this.impl.execute(this.request);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToHttpUriRequestWithContext() throws Exception {
        this.impl.execute(this.request, this.ctx);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToHostAndHttpRequest() throws Exception {
        this.impl.execute(this.host, (HttpRequest)this.request);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToHostAndHttpRequestWithContext() throws Exception {
        this.impl.execute(this.host, (HttpRequest)this.request, this.ctx);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToUriRequestWithHandler() throws Exception {
        Mockito.when((Object)this.mockHandler.handleResponse((HttpResponse)Matchers.isA(HttpResponse.class))).thenReturn(new Object());
        this.impl.execute(this.request, this.mockHandler);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToUriRequestWithHandlerAndContext() throws Exception {
        Mockito.when((Object)this.mockHandler.handleResponse((HttpResponse)Matchers.isA(HttpResponse.class))).thenReturn(new Object());
        this.impl.execute(this.request, this.mockHandler, this.ctx);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToRequestWithHostAndHandler() throws Exception {
        Mockito.when((Object)this.mockHandler.handleResponse((HttpResponse)Matchers.isA(HttpResponse.class))).thenReturn(new Object());
        this.impl.execute(this.host, (HttpRequest)this.request, this.mockHandler);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    @Test
    public void addsAcceptEncodingHeaderToRequestWithHostAndContextAndHandler() throws Exception {
        Mockito.when((Object)this.mockHandler.handleResponse((HttpResponse)Matchers.isA(HttpResponse.class))).thenReturn(new Object());
        this.impl.execute(this.host, (HttpRequest)this.request, this.mockHandler, this.ctx);
        this.assertAcceptEncodingGzipAndDeflateWereAddedToRequest(this.backend.getCapturedRequest());
    }

    private void mockResponseHasNoContentEncodingHeaders() {
        this.backend.setResponse(this.mockResponse);
        Mockito.when((Object)this.mockResponse.getAllHeaders()).thenReturn((Object)new Header[0]);
        Mockito.when((Object)this.mockResponse.getHeaders("Content-Encoding")).thenReturn((Object)new Header[0]);
        Mockito.when((Object)this.mockResponse.getFirstHeader("Content-Encoding")).thenReturn(null);
        Mockito.when((Object)this.mockResponse.getLastHeader("Content-Encoding")).thenReturn(null);
        Mockito.when((Object)this.mockResponse.getEntity()).thenReturn((Object)this.mockEntity);
    }

    @Test
    public void doesNotModifyResponseBodyIfNoContentEncoding() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Assert.assertSame((Object)this.mockResponse, (Object)this.impl.execute(this.request));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyIfNoContentEncodingWithContext() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Assert.assertSame((Object)this.mockResponse, (Object)this.impl.execute(this.request, this.ctx));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyIfNoContentEncodingForHostRequest() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Assert.assertSame((Object)this.mockResponse, (Object)this.impl.execute(this.host, (HttpRequest)this.request));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyIfNoContentEncodingForHostRequestWithContext() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Assert.assertSame((Object)this.mockResponse, (Object)this.impl.execute(this.host, (HttpRequest)this.request, this.ctx));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyWithHandlerIfNoContentEncoding() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Mockito.when((Object)this.mockHandler.handleResponse(this.mockResponse)).thenReturn(this.handled);
        Assert.assertSame((Object)this.handled, (Object)this.impl.execute(this.request, this.mockHandler));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyWithHandlerAndContextIfNoContentEncoding() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Mockito.when((Object)this.mockHandler.handleResponse(this.mockResponse)).thenReturn(this.handled);
        Assert.assertSame((Object)this.handled, (Object)this.impl.execute(this.request, this.mockHandler, this.ctx));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyWithHostAndHandlerIfNoContentEncoding() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Mockito.when((Object)this.mockHandler.handleResponse(this.mockResponse)).thenReturn(this.handled);
        Assert.assertSame((Object)this.handled, (Object)this.impl.execute(this.host, (HttpRequest)this.request, this.mockHandler));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void doesNotModifyResponseBodyWithHostAndHandlerAndContextIfNoContentEncoding() throws Exception {
        this.mockResponseHasNoContentEncodingHeaders();
        Mockito.when((Object)this.mockHandler.handleResponse(this.mockResponse)).thenReturn(this.handled);
        Assert.assertSame((Object)this.handled, (Object)this.impl.execute(this.host, (HttpRequest)this.request, this.mockHandler, this.ctx));
        ((HttpResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setEntity((HttpEntity)Matchers.any(HttpEntity.class));
    }

    @Test
    public void successfullyUncompressesContent() throws Exception {
        int b;
        String plainText = "hello\n";
        HttpResponse response = this.getGzippedResponse("hello\n");
        this.backend.setResponse(response);
        HttpResponse result = this.impl.execute(this.request);
        ByteArrayOutputStream resultBuf = new ByteArrayOutputStream();
        InputStream is = result.getEntity().getContent();
        while ((b = is.read()) != -1) {
            resultBuf.write(b);
        }
        is.close();
        Assert.assertEquals((Object)"hello\n", (Object)new String(resultBuf.toByteArray()));
    }

    @Test
    public void uncompressedResponseHasUnknownLength() throws Exception {
        String plainText = "hello\n";
        HttpResponse response = this.getGzippedResponse("hello\n");
        this.backend.setResponse(response);
        HttpResponse result = this.impl.execute(this.request);
        HttpEntity entity = result.getEntity();
        Assert.assertEquals((long)-1L, (long)entity.getContentLength());
        EntityUtils.consume((HttpEntity)entity);
        Assert.assertNull((Object)result.getFirstHeader("Content-Length"));
    }

    @Test
    public void uncompressedResponseIsNotEncoded() throws Exception {
        String plainText = "hello\n";
        HttpResponse response = this.getGzippedResponse("hello\n");
        this.backend.setResponse(response);
        HttpResponse result = this.impl.execute(this.request);
        Assert.assertNull((Object)result.getFirstHeader("Content-Encoding"));
    }

    @Test
    public void uncompressedResponseHasContentMD5Removed() throws Exception {
        String plainText = "hello\n";
        HttpResponse response = this.getGzippedResponse("hello\n");
        response.setHeader("Content-MD5", "a checksum");
        this.backend.setResponse(response);
        HttpResponse result = this.impl.execute(this.request);
        Assert.assertNull((Object)result.getFirstHeader("Content-MD5"));
    }

    @Test
    public void unencodedResponseRetainsContentMD5() throws Exception {
        String plainText = "hello\n";
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setHeader("Content-MD5", "a checksum");
        response.setEntity((HttpEntity)new ByteArrayEntity("hello\n".getBytes()));
        this.backend.setResponse((HttpResponse)response);
        HttpResponse result = this.impl.execute(this.request);
        Assert.assertNotNull((Object)result.getFirstHeader("Content-MD5"));
    }

    @Test
    public void passesThroughTheBodyOfAPOST() throws Exception {
        Mockito.when((Object)this.mockHandler.handleResponse((HttpResponse)Matchers.isA(HttpResponse.class))).thenReturn(new Object());
        HttpPost post = new HttpPost("http://localhost:8080/");
        post.setEntity((HttpEntity)new ByteArrayEntity("hello".getBytes()));
        this.impl.execute(this.host, (HttpRequest)post, this.mockHandler, this.ctx);
        Assert.assertNotNull((Object)((HttpEntityEnclosingRequest)this.backend.getCapturedRequest()).getEntity());
    }

    private HttpResponse getGzippedResponse(String plainText) throws IOException {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setHeader("Content-Encoding", "gzip");
        response.setHeader("Content-Type", "text/plain");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(buf);
        gos.write(plainText.getBytes());
        gos.close();
        ByteArrayEntity body = new ByteArrayEntity(buf.toByteArray());
        body.setContentEncoding("gzip");
        body.setContentType("text/plain");
        response.setHeader("Content-Length", "" + (int)body.getContentLength());
        response.setEntity((HttpEntity)body);
        return response;
    }
}

