/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.HttpConnPool;
import org.apache.http.impl.conn.HttpPoolEntry;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.pool.PoolEntry;

public class ConnPoolBench {
    private static final HttpRoute ROUTE = new HttpRoute(new HttpHost("localhost"));

    public static void main(String[] args) throws Exception {
        int c = 200;
        long reps = 100000L;
        ConnPoolBench.oldPool(c, reps);
        ConnPoolBench.newPool(c, reps);
    }

    public static void newPool(int c, long reps) throws Exception {
        int i;
        Log log = LogFactory.getLog(ConnPoolBench.class);
        DefaultClientConnectionOperator connOperator = new DefaultClientConnectionOperator(SchemeRegistryFactory.createDefault());
        HttpConnPool pool = new HttpConnPool(log, (ClientConnectionOperator)connOperator, c, c * 10, -1L, TimeUnit.MILLISECONDS);
        WorkerThread1[] workers = new WorkerThread1[c];
        for (int i2 = 0; i2 < workers.length; ++i2) {
            workers[i2] = new WorkerThread1(pool, reps);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < workers.length; ++i) {
            workers[i].start();
        }
        for (i = 0; i < workers.length; ++i) {
            workers[i].join();
        }
        long finish = System.currentTimeMillis();
        float totalTimeSec = (float)(finish - start) / 1000.0f;
        System.out.print("Concurrency level:\t");
        System.out.println(c);
        System.out.print("Total operations:\t");
        System.out.println((long)c * reps);
        System.out.print("Time taken for tests:\t");
        System.out.print(totalTimeSec);
        System.out.println(" seconds");
    }

    static void oldPool(int c, long reps) throws Exception {
        int i;
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(SchemeRegistryFactory.createDefault());
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(c);
        ConnPoolByRoute pool = new ConnPoolByRoute((ClientConnectionOperator)operator, (ConnPerRoute)connPerRoute, c * 10);
        WorkerThread2[] workers = new WorkerThread2[c];
        for (int i2 = 0; i2 < workers.length; ++i2) {
            workers[i2] = new WorkerThread2(pool, reps);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < workers.length; ++i) {
            workers[i].start();
        }
        for (i = 0; i < workers.length; ++i) {
            workers[i].join();
        }
        long finish = System.currentTimeMillis();
        float totalTimeSec = (float)(finish - start) / 1000.0f;
        System.out.print("Concurrency level:\t");
        System.out.println(c);
        System.out.print("Total operations:\t");
        System.out.println((long)c * reps);
        System.out.print("Time taken for tests:\t");
        System.out.print(totalTimeSec);
        System.out.println(" seconds");
    }

    static class WorkerThread2
    extends Thread {
        private final ConnPoolByRoute pool;
        private final long reps;

        WorkerThread2(ConnPoolByRoute pool, long reps) {
            this.pool = pool;
            this.reps = reps;
        }

        public void run() {
            for (long c = 0L; c < this.reps; ++c) {
                PoolEntryRequest request = this.pool.requestPoolEntry(ROUTE, null);
                try {
                    BasicPoolEntry entry = request.getPoolEntry(-1L, TimeUnit.MILLISECONDS);
                    this.pool.freeEntry(entry, true, -1L, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (ConnectionPoolTimeoutException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class WorkerThread1
    extends Thread {
        private final HttpConnPool pool;
        private final long reps;

        WorkerThread1(HttpConnPool pool, long reps) {
            this.pool = pool;
            this.reps = reps;
        }

        public void run() {
            for (long c = 0L; c < this.reps; ++c) {
                Future future = this.pool.lease((Object)ROUTE, null);
                try {
                    HttpPoolEntry entry = (HttpPoolEntry)future.get(-1L, TimeUnit.MILLISECONDS);
                    this.pool.release((PoolEntry)entry, true);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

