/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.message.BasicHeader;
import org.apache.http.mockup.SocketFactoryMockup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbortHandling
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        this.httpclient = new DefaultHttpClient();
    }

    @Test
    public void testAbortRetry_HTTPCLIENT_1120() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        final CountDownLatch wait = new CountDownLatch(1);
        this.localServer.register("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                try {
                    wait.countDown();
                    Thread.sleep(2000L);
                    response.setStatusCode(200);
                    StringEntity entity = new StringEntity("Whatever");
                    response.setEntity((HttpEntity)entity);
                }
                catch (Exception e) {
                    response.setStatusCode(408);
                }
            }
        });
        String s = "http://localhost:" + port + "/path";
        final HttpGet httpget = new HttpGet(s);
        Thread t = new Thread(){

            public void run() {
                try {
                    wait.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                httpget.abort();
            }
        };
        t.start();
        BasicHttpContext context = new BasicHttpContext();
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertNotNull((String)"Request should exist", (Object)reqWrapper);
        Assert.assertEquals((long)1L, (long)((RequestWrapper)reqWrapper).getExecCount());
    }

    @Test
    public void testAbortInAllocate() throws Exception {
        CountDownLatch connLatch = new CountDownLatch(1);
        CountDownLatch awaitLatch = new CountDownLatch(1);
        ConMan conMan = new ConMan(connLatch, awaitLatch);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("http://www.example.com/a");
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    client.execute((HttpUriRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((String)"should have tried to get a connection", (boolean)connLatch.await(1L, TimeUnit.SECONDS));
        httpget.abort();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortAfterAllocateBeforeRequest() throws Exception {
        this.localServer.register("*", new BasicService());
        CountDownLatch releaseLatch = new CountDownLatch(1);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager conMan = new PoolingClientConnectionManager(registry);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final CustomGet httpget = new CustomGet("a", releaseLatch);
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    client.execute(TestAbortHandling.this.getServerHttp(), (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Thread.sleep(100L);
        httpget.abort();
        releaseLatch.countDown();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortBeforeExecute() throws Exception {
        this.localServer.register("*", new BasicService());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager conMan = new PoolingClientConnectionManager(registry);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("a");
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        if (!startLatch.await(1L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Took too long to start!");
                        }
                    }
                    catch (InterruptedException interrupted) {
                        throw new RuntimeException("Never started!", interrupted);
                    }
                    client.execute(TestAbortHandling.this.getServerHttp(), (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        httpget.abort();
        startLatch.countDown();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortAfterRedirectedRoute() throws Exception {
        final int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new BasicRedirectService(port));
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        CountDownLatch connLatch = new CountDownLatch(1);
        CountDownLatch awaitLatch = new CountDownLatch(1);
        ConnMan4 conMan = new ConnMan4(registry, connLatch, awaitLatch);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("a");
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    HttpHost host = new HttpHost("127.0.0.1", port);
                    client.execute(host, (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((String)"should have tried to get a connection", (boolean)connLatch.await(1L, TimeUnit.SECONDS));
        httpget.abort();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testSocketConnectFailureReleasesConnection() throws Exception {
        ManagedClientConnection conn = (ManagedClientConnection)Mockito.mock(ManagedClientConnection.class);
        ((ManagedClientConnection)Mockito.doThrow((Throwable)new ConnectException()).when((Object)conn)).open((HttpRoute)Mockito.any(HttpRoute.class), (HttpContext)Mockito.any(HttpContext.class), (HttpParams)Mockito.any(HttpParams.class));
        ClientConnectionRequest connrequest = (ClientConnectionRequest)Mockito.mock(ClientConnectionRequest.class);
        Mockito.when((Object)connrequest.getConnection((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)conn);
        ClientConnectionManager connmgr = (ClientConnectionManager)Mockito.mock(ClientConnectionManager.class);
        SchemeRegistry schemeRegistry = SchemeRegistryFactory.createDefault();
        Mockito.when((Object)connmgr.requestConnection((HttpRoute)Mockito.any(HttpRoute.class), Mockito.any())).thenReturn((Object)connrequest);
        Mockito.when((Object)connmgr.getSchemeRegistry()).thenReturn((Object)schemeRegistry);
        DefaultHttpClient client = new DefaultHttpClient(connmgr, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("http://www.example.com/a");
        try {
            client.execute((HttpUriRequest)httpget, (HttpContext)context);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        ((ManagedClientConnection)Mockito.verify((Object)conn)).abortConnection();
    }

    private static class CustomGet
    extends HttpGet {
        private final CountDownLatch releaseTriggerLatch;

        public CustomGet(String uri, CountDownLatch releaseTriggerLatch) {
            super(uri);
            this.releaseTriggerLatch = releaseTriggerLatch;
        }

        public void setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) throws IOException {
            try {
                if (!this.releaseTriggerLatch.await(1L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Waited too long...");
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            super.setReleaseTrigger(releaseTrigger);
        }
    }

    static class ConMan
    implements ClientConnectionManager {
        private final CountDownLatch connLatch;
        private final CountDownLatch awaitLatch;

        public ConMan(CountDownLatch connLatch, CountDownLatch awaitLatch) {
            this.connLatch = connLatch;
            this.awaitLatch = awaitLatch;
        }

        public void closeIdleConnections(long idletime, TimeUnit tunit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void closeExpiredConnections() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ManagedClientConnection getConnection(HttpRoute route) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ManagedClientConnection getConnection(HttpRoute route, long timeout, TimeUnit tunit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            final Thread currentThread = Thread.currentThread();
            return new ClientConnectionRequest(){

                public void abortRequest() {
                    currentThread.interrupt();
                }

                public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                    ConMan.this.connLatch.countDown();
                    if (timeout == 0L) {
                        timeout = Integer.MAX_VALUE;
                    }
                    if (!ConMan.this.awaitLatch.await(timeout, tunit)) {
                        throw new ConnectionPoolTimeoutException();
                    }
                    return (ManagedClientConnection)Mockito.mock(ManagedClientConnection.class);
                }
            };
        }

        public HttpParams getParams() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public SchemeRegistry getSchemeRegistry() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)new SocketFactoryMockup(null)));
            return registry;
        }

        public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void shutdown() {
            throw new UnsupportedOperationException("just a mockup");
        }
    }

    private static class ConnMan4
    extends PoolingClientConnectionManager {
        private final CountDownLatch connLatch;
        private final CountDownLatch awaitLatch;

        public ConnMan4(SchemeRegistry schreg, CountDownLatch connLatch, CountDownLatch awaitLatch) {
            super(schreg);
            this.connLatch = connLatch;
            this.awaitLatch = awaitLatch;
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            if (route.getTargetHost().getHostName().equals("localhost")) {
                final Thread currentThread = Thread.currentThread();
                return new ClientConnectionRequest(){

                    public void abortRequest() {
                        currentThread.interrupt();
                    }

                    public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                        ConnMan4.this.connLatch.countDown();
                        if (timeout == 0L) {
                            timeout = Integer.MAX_VALUE;
                        }
                        if (!ConnMan4.this.awaitLatch.await(timeout, tunit)) {
                            throw new ConnectionPoolTimeoutException();
                        }
                        return (ManagedClientConnection)Mockito.mock(ManagedClientConnection.class);
                    }
                };
            }
            return super.requestConnection(route, state);
        }
    }

    private static class BasicRedirectService
    implements HttpRequestHandler {
        private int statuscode = 303;
        private int port;

        public BasicRedirectService(int port) {
            this.port = port;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(ver, this.statuscode);
            response.addHeader((Header)new BasicHeader("Location", "http://localhost:" + this.port + "/newlocation/"));
            response.addHeader((Header)new BasicHeader("Connection", "close"));
        }
    }

    private static class BasicService
    implements HttpRequestHandler {
        private BasicService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            response.setEntity((HttpEntity)new StringEntity("Hello World"));
        }
    }
}

