/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.Assert;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.PublicSuffixFilter;
import org.apache.http.impl.cookie.PublicSuffixListParser;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.junit.Before;
import org.junit.Test;

public class TestPublicSuffixListParser {
    private static final String LIST_FILE = "/suffixlist.txt";
    private PublicSuffixFilter filter;

    @Before
    public void setUp() throws Exception {
        InputStreamReader r = new InputStreamReader(this.getClass().getResourceAsStream(LIST_FILE), "UTF-8");
        this.filter = new PublicSuffixFilter((CookieAttributeHandler)new RFC2109DomainHandler());
        PublicSuffixListParser parser = new PublicSuffixListParser(this.filter);
        parser.parse((Reader)r);
    }

    @Test
    public void testParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.jp", 80, "/stuff", false)));
        cookie.setDomain(".ac.jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.ac.jp", 80, "/stuff", false)));
        cookie.setDomain(".any.tokyo.jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.any.tokyo.jp", 80, "/stuff", false)));
        cookie.setDomain(".metro.tokyo.jp");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.metro.tokyo.jp", 80, "/stuff", false)));
    }

    @Test
    public void testUnicode() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".h\u00e5.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.h\u00e5.no", 80, "/stuff", false)));
        cookie.setDomain(".xn--h-2fa.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xn--h-2fa.no", 80, "/stuff", false)));
        cookie.setDomain(".h\u00e5.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xn--h-2fa.no", 80, "/stuff", false)));
        cookie.setDomain(".xn--h-2fa.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.h\u00e5.no", 80, "/stuff", false)));
    }

    @Test
    public void testWhitespace() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".xx");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xx", 80, "/stuff", false)));
        cookie.setDomain(".yy");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.yy", 80, "/stuff", false)));
        cookie.setDomain(".zz");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.zz", 80, "/stuff", false)));
    }
}

