/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import java.net.InetSocketAddress;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.localserver.LocalTestServer;
import org.junit.After;
import org.mockito.Mockito;

public abstract class BasicServerTestBase
extends Mockito {
    protected LocalTestServer localServer;
    protected DefaultHttpClient httpclient;

    @After
    public void shutDownClient() throws Exception {
        if (this.httpclient != null) {
            this.httpclient.getConnectionManager().shutdown();
        }
    }

    @After
    public void shutDownServer() throws Exception {
        if (this.localServer != null) {
            this.localServer.stop();
        }
    }

    protected HttpHost getServerHttp() {
        InetSocketAddress address = this.localServer.getServiceAddress();
        return new HttpHost(address.getHostName(), address.getPort(), "http");
    }
}

