/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestBrowserCompatSpec {
    @Test
    public void testConstructor() throws Exception {
        new BrowserCompatSpec();
        new BrowserCompatSpec(null);
        new BrowserCompatSpec(new String[]{"EEE, dd-MMM-yy HH:mm:ss zzz"});
    }

    @Test
    public void testDomainCaseInsensitivity() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.whatever.com");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.WhatEver.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)".whatever.com", (Object)((Cookie)cookies.get(0)).getDomain());
    }

    @Test
    public void testParse1() throws Exception {
        String headerValue = "custno = 12345; comment=test; version=1, name=John; version=1; max-age=600; secure; domain=.apache.org";
        BasicHeader header = new BasicHeader("set-cookie", "custno = 12345; comment=test; version=1, name=John; version=1; max-age=600; secure; domain=.apache.org");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((long)2L, (long)cookies.size());
        Assert.assertEquals((Object)"custno", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"12345", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"test", (Object)((Cookie)cookies.get(0)).getComment());
        Assert.assertEquals((long)1L, (long)((Cookie)cookies.get(0)).getVersion());
        Assert.assertEquals((Object)"www.apache.org", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertFalse((boolean)((Cookie)cookies.get(0)).isSecure());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertEquals(null, (Object)((Cookie)cookies.get(1)).getComment());
        Assert.assertEquals((long)1L, (long)((Cookie)cookies.get(1)).getVersion());
        Assert.assertEquals((Object)".apache.org", (Object)((Cookie)cookies.get(1)).getDomain());
        Assert.assertEquals((Object)"/", (Object)((Cookie)cookies.get(1)).getPath());
        Assert.assertTrue((boolean)((Cookie)cookies.get(1)).isSecure());
    }

    @Test
    public void testParse2() throws Exception {
        String headerValue = "custno=12345;comment=test; version=1,name=John;version=1;max-age=600;secure;domain=.apache.org";
        BasicHeader header = new BasicHeader("set-cookie", "custno=12345;comment=test; version=1,name=John;version=1;max-age=600;secure;domain=.apache.org");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((long)2L, (long)cookies.size());
        Assert.assertEquals((Object)"custno", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"12345", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"test", (Object)((Cookie)cookies.get(0)).getComment());
        Assert.assertEquals((long)1L, (long)((Cookie)cookies.get(0)).getVersion());
        Assert.assertEquals((Object)"www.apache.org", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertFalse((boolean)((Cookie)cookies.get(0)).isSecure());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertEquals(null, (Object)((Cookie)cookies.get(1)).getComment());
        Assert.assertEquals((long)1L, (long)((Cookie)cookies.get(1)).getVersion());
        Assert.assertEquals((Object)".apache.org", (Object)((Cookie)cookies.get(1)).getDomain());
        Assert.assertEquals((Object)"/", (Object)((Cookie)cookies.get(1)).getPath());
        Assert.assertTrue((boolean)((Cookie)cookies.get(1)).isSecure());
    }

    @Test
    public void testParse3() throws Exception {
        String headerValue = "name=\"Doe, John\";version=1;max-age=600;secure;domain=.apache.org";
        BasicHeader header = new BasicHeader("set-cookie", "name=\"Doe, John\";version=1;max-age=600;secure;domain=.apache.org");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"Doe, John", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals(null, (Object)((Cookie)cookies.get(0)).getComment());
        Assert.assertEquals((long)1L, (long)((Cookie)cookies.get(0)).getVersion());
        Assert.assertEquals((Object)".apache.org", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((boolean)((Cookie)cookies.get(0)).isSecure());
    }

    @Test
    public void testQuotedExpiresAttribute() throws Exception {
        String headerValue = "custno=12345;Expires='Thu, 01-Jan-2070 00:00:10 GMT'";
        BasicHeader header = new BasicHeader("set-cookie", "custno=12345;Expires='Thu, 01-Jan-2070 00:00:10 GMT'");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((String)"Expected some cookies", (Object)cookies);
        Assert.assertEquals((String)"Expected 1 cookie", (long)1L, (long)cookies.size());
        Assert.assertNotNull((String)"Expected cookie to have getExpiryDate", (Object)((Cookie)cookies.get(0)).getExpiryDate());
    }

    @Test
    public void testSecurityError() throws Exception {
        String headerValue = "custno=12345;comment=test; version=1,name=John;version=1;max-age=600;secure;domain=jakarta.apache.org";
        BasicHeader header = new BasicHeader("set-cookie", "custno=12345;comment=test; version=1,name=John;version=1;max-age=600;secure;domain=jakarta.apache.org");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", true);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testParseSimple() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/path/path", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"isPersistent", (!((Cookie)cookies.get(0)).isPersistent() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/path", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Version", (long)0L, (long)((Cookie)cookies.get(0)).getVersion());
    }

    @Test
    public void testParseSimple2() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/path", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"isPersistent", (!((Cookie)cookies.get(0)).isPersistent() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Version", (long)0L, (long)((Cookie)cookies.get(0)).getVersion());
    }

    @Test
    public void testParseNoName() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "=stuff; path=/");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testParseNoValue() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"isPersistent", (!((Cookie)cookies.get(0)).isPersistent() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Version", (long)0L, (long)((Cookie)cookies.get(0)).getVersion());
    }

    @Test
    public void testParseWithWhiteSpace() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", " cookie-name  =    cookie-value  ");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithQuotes() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", " cookie-name  =  \" cookie-value \" ;path=/");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"\" cookie-value \"", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithPath() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; Path=/path/");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/path/path", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/path/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithDomain() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; Domain=127.0.0.1");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithSecure() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; secure");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (boolean)((Cookie)cookies.get(0)).isSecure());
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithComment() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; comment=\"This is a comment.\"");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertTrue((String)"ExpiryDate", (null == ((Cookie)cookies.get(0)).getExpiryDate() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Comment", (Object)"\"This is a comment.\"", (Object)((Cookie)cookies.get(0)).getComment());
    }

    @Test
    public void testParseWithExpires() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value;Expires=Thu, 01-Jan-1970 00:00:10 GMT");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"127.0.0.1", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (!((Cookie)cookies.get(0)).isSecure() ? 1 : 0) != 0);
        Assert.assertEquals((Object)new Date(10000L), (Object)((Cookie)cookies.get(0)).getExpiryDate());
        Assert.assertTrue((String)"Comment", (null == ((Cookie)cookies.get(0)).getComment() ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithAll() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value;Version=1;Path=/commons;Domain=.apache.org;Comment=This is a comment.;secure;Expires=Thu, 01-Jan-1970 00:00:10 GMT");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/commons/httpclient", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)".apache.org", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/commons", (Object)((Cookie)cookies.get(0)).getPath());
        Assert.assertTrue((String)"Secure", (boolean)((Cookie)cookies.get(0)).isSecure());
        Assert.assertEquals((Object)new Date(10000L), (Object)((Cookie)cookies.get(0)).getExpiryDate());
        Assert.assertEquals((String)"Comment", (Object)"This is a comment.", (Object)((Cookie)cookies.get(0)).getComment());
        Assert.assertEquals((String)"Version", (long)1L, (long)((Cookie)cookies.get(0)).getVersion());
    }

    @Test
    public void testParseMultipleDifferentPaths() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1;Version=1;Path=/commons,name1=value2;Version=1;Path=/commons/httpclient;Version=1");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/commons/httpclient", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Wrong number of cookies.", (long)2L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"value1", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((String)"Value", (Object)"value2", (Object)((Cookie)cookies.get(1)).getValue());
    }

    @Test
    public void testParseRelativePath() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1;Path=whatever");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "whatever", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookies.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"value1", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Path", (Object)"whatever", (Object)((Cookie)cookies.get(0)).getPath());
    }

    @Test
    public void testParseWithWrongDomain() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=127.0.0.1; version=1");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.2", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testParseWithPathMismatch() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; path=/path/path/path");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/path", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown.");
        }
        catch (MalformedCookieException e) {
            // empty catch block
        }
    }

    @Test
    public void testParseWithPathMismatch2() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; path=/foobar");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/foo", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown.");
        }
        catch (MalformedCookieException e) {
            // empty catch block
        }
    }

    @Test
    public void testCookieNameWithBlanks() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "invalid name=");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
    }

    @Test
    public void testCookieNameBlank() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "=stuff");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException expected) {
            // empty catch block
        }
    }

    @Test
    public void testCookieNameStartingWithDollarSign() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "$invalid_name=");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
    }

    @Test
    public void testCookieWithComma() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; expires=\"Thu, 01-Jan-1970 00:00:00 GMT");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException expected) {
            // empty catch block
        }
    }

    @Test
    public void testDateFormats() throws Exception {
        this.checkDate("Thu, 01-Jan-70 00:00:10 GMT");
        this.checkDate("Thu, 01-Jan-2070 00:00:10 GMT");
        this.checkDate("Thu 01-Jan-70 00:00:10 GMT");
        this.checkDate("Thu 01-Jan-2070 00:00:10 GMT");
        this.checkDate("Thu, 01 Jan 70 00:00:10 GMT");
        this.checkDate("Thu, 01 Jan 2070 00:00:10 GMT");
        this.checkDate("Thu 01 Jan 70 00:00:10 GMT");
        this.checkDate("Thu 01 Jan 2070 00:00:10 GMT");
        this.checkDate("Wed, 20-Nov-2002 09-38-33 GMT");
        try {
            this.checkDate("this aint a date");
            Assert.fail((String)"Date check is bogus");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkDate(String date) throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "custno=12345;Expires='" + date + "';");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
    }

    @Test
    public void testSecondDomainLevelCookie() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("sourceforge.net", 80, "/", false);
        cookiespec.validate((Cookie)cookie, origin);
    }

    @Test
    public void testSecondDomainLevelCookieMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("sourceforge.net", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testSecondDomainLevelCookieMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain("sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.sourceforge.net", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testSecondDomainLevelCookieMatch3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("www.sourceforge.net", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testInvalidSecondDomainLevelCookieMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("antisourceforge.net", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testInvalidSecondDomainLevelCookieMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain("sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("antisourceforge.net", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testMatchBlankPath() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin("host", 80, "  ", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testMatchNullCookieDomain() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin("host", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testMatchNullCookiePath() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        CookieOrigin origin = new CookieOrigin("host", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMatch1() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin("host", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMatch2() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".whatever.com");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin(".whatever.com", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMatch3() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".whatever.com");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin(".really.whatever.com", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMatch4() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin("host", 80, "/foobar", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMismatch1() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host1");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin("host2", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMismatch2() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".aaaaaaaaa.com");
        cookie.setPath("/");
        CookieOrigin origin = new CookieOrigin(".bbbbbbbb.com", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMismatch3() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/foobar");
        CookieOrigin origin = new CookieOrigin("host", 80, "/foo", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMismatch4() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/foobar");
        CookieOrigin origin = new CookieOrigin("host", 80, "/foobar/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMatch5() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/foobar/r");
        CookieOrigin origin = new CookieOrigin("host", 80, "/foobar/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieMismatch6() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("host");
        cookie.setPath("/foobar");
        cookie.setSecure(true);
        CookieOrigin origin = new CookieOrigin("host", 80, "/foobar", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testInvalidMatchDomain() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain("beta.gamma.com");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("alpha.beta.gamma.com", 80, "/", false);
        cookiespec.validate((Cookie)cookie, origin);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testGenericCookieFormatting() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"name=value", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testNullCookieValueFormatting() {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".whatever.com");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>(1);
        cookies.add(cookie);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"name=", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testNullCookieValueFormattingCookieVersion1() {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setVersion(1);
        cookie.setDomain(".whatever.com");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>(1);
        cookies.add(cookie);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"name", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testFormatSeveralCookies() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1; path=/; domain=.mydomain.com, name2 = value2 ; path=/; domain=.mydomain.com; version=0");
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testKeepCloverHappy() throws Exception {
        new MalformedCookieException();
        new MalformedCookieException("whatever");
        new MalformedCookieException("whatever", null);
    }

    @Test
    public void testInvalidInput() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        try {
            cookiespec.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.parse((Header)new BasicHeader("Set-Cookie", "name=value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.validate(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.validate((Cookie)new BasicClientCookie("name", null), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.match(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.match((Cookie)new BasicClientCookie("name", null), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.formatCookies(null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayList cookies = new ArrayList();
            cookiespec.formatCookies(cookies);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFormatCookieWithSpaceInValue() throws Exception {
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        BrowserCompatSpec cookieSpec = new BrowserCompatSpec();
        BasicHeader setCookieHeader = new BasicHeader("Set-Cookie", "test=\"value 1\"; Version=1");
        Cookie cookie = (Cookie)cookieSpec.parse((Header)setCookieHeader, origin).get(0);
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookies.add(cookie);
        List headers = cookieSpec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"test=\"value 1\"", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testFormatCookieVersion0WithSpaceInValue() throws Exception {
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        BrowserCompatSpec cookieSpec = new BrowserCompatSpec();
        BasicHeader setCookieHeader = new BasicHeader("Set-Cookie", "test=value 1");
        Cookie cookie = (Cookie)cookieSpec.parse((Header)setCookieHeader, origin).get(0);
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookies.add(cookie);
        List headers = cookieSpec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"test=value 1", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testVersion1CookieWithInvalidExpires() throws Exception {
        BrowserCompatSpec cookiespec = new BrowserCompatSpec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        BasicHeader origHeader = new BasicHeader("Set-Cookie", "test=\"test\"; Version=1; Expires=Mon, 11-Feb-2013 10:39:19 GMT; Path=/");
        List cookies = cookiespec.parse((Header)origHeader, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header1 = (Header)headers.get(0);
        Assert.assertEquals((Object)"test=\"test\"", (Object)header1.getValue());
    }
}

