/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.PrivateKeyDetails;
import org.apache.http.conn.ssl.PrivateKeyStrategy;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSSLSocketFactory
extends LocalServerTestBase {
    private KeyStore keystore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        this.keystore = KeyStore.getInstance("jks");
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource("hc-test.keystore");
        InputStream instream = url.openStream();
        try {
            this.keystore.load(instream, "nopassword".toCharArray());
        }
        finally {
            instream.close();
        }
    }

    protected HttpHost getServerHttp() {
        InetSocketAddress address = this.localServer.getServiceAddress();
        return new HttpHost(address.getHostName(), address.getPort(), "https");
    }

    @Test
    public void testBasicSSL() throws Exception {
        SSLContext serverSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        SSLContext clientSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).build();
        this.localServer = new LocalTestServer(serverSSLContext);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        HttpHost host = new HttpHost("localhost", 443, "https");
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(clientSSLContext, (X509HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = this.localServer.getServiceAddress();
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, host, remoteAddress, null, (HttpContext)context);
        SSLSession sslsession = sslSocket.getSession();
        Assert.assertNotNull((Object)sslsession);
        Assert.assertTrue((boolean)hostVerifier.isFired());
    }

    @Test
    public void testClientAuthSSL() throws Exception {
        SSLContext serverSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        SSLContext clientSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        this.localServer = new LocalTestServer(serverSSLContext, true);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        HttpHost host = new HttpHost("localhost", 443, "https");
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(clientSSLContext, (X509HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = this.localServer.getServiceAddress();
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, host, remoteAddress, null, (HttpContext)context);
        SSLSession sslsession = sslSocket.getSession();
        Assert.assertNotNull((Object)sslsession);
        Assert.assertTrue((boolean)hostVerifier.isFired());
    }

    @Test(expected=IOException.class)
    public void testClientAuthSSLFailure() throws Exception {
        SSLContext serverSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        SSLContext clientSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).build();
        this.localServer = new LocalTestServer(serverSSLContext, true);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        HttpHost host = new HttpHost("localhost", 443, "https");
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(clientSSLContext, (X509HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = this.localServer.getServiceAddress();
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, host, remoteAddress, null, (HttpContext)context);
        SSLSession sslsession = sslSocket.getSession();
        Assert.assertNotNull((Object)sslsession);
        Assert.assertTrue((boolean)hostVerifier.isFired());
    }

    @Test
    public void testClientAuthSSLAliasChoice() throws Exception {
        PrivateKeyStrategy aliasStrategy = new PrivateKeyStrategy(){

            public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                Assert.assertEquals((long)2L, (long)aliases.size());
                Assert.assertTrue((boolean)aliases.containsKey("hc-test-key-1"));
                Assert.assertTrue((boolean)aliases.containsKey("hc-test-key-2"));
                return "hc-test-key-2";
            }
        };
        SSLContext serverSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        SSLContext clientSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray(), aliasStrategy).build();
        this.localServer = new LocalTestServer(serverSSLContext, true);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        HttpHost host = new HttpHost("localhost", 443, "https");
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(clientSSLContext, (X509HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = this.localServer.getServiceAddress();
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, host, remoteAddress, null, (HttpContext)context);
        SSLSession sslsession = sslSocket.getSession();
        Assert.assertNotNull((Object)sslsession);
        Assert.assertTrue((boolean)hostVerifier.isFired());
    }

    @Test(expected=SSLHandshakeException.class)
    public void testSSLTrustVerification() throws Exception {
        SSLContext serverSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        this.localServer = new LocalTestServer(serverSSLContext);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        HttpHost host = new HttpHost("localhost", 443, "https");
        BasicHttpContext context = new BasicHttpContext();
        SSLContext defaultsslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(defaultsslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = this.localServer.getServiceAddress();
        socketFactory.connectSocket(0, socket, host, remoteAddress, null, (HttpContext)context);
    }

    @Test
    public void testSSLTrustVerificationOverride() throws Exception {
        SSLContext serverSSLContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(this.keystore).loadKeyMaterial(this.keystore, "nopassword".toCharArray()).build();
        this.localServer = new LocalTestServer(serverSSLContext);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        HttpHost host = new HttpHost("localhost", 443, "https");
        BasicHttpContext context = new BasicHttpContext();
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return chain.length == 1;
            }
        };
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, trustStrategy).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = this.localServer.getServiceAddress();
        socketFactory.connectSocket(0, socket, host, remoteAddress, null, (HttpContext)context);
    }

    @Test
    public void testDefaultHostnameVerifier() throws Exception {
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLContexts.createDefault(), null);
        Assert.assertNotNull((Object)socketFactory.getHostnameVerifier());
    }

    static class TestX509HostnameVerifier
    implements X509HostnameVerifier {
        private boolean fired = false;

        TestX509HostnameVerifier() {
        }

        public boolean verify(String host, SSLSession session) {
            return true;
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            this.fired = true;
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
        }

        public boolean isFired() {
            return this.fired;
        }
    }
}

