/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import org.apache.http.cookie.CookieOrigin;
import org.junit.Assert;
import org.junit.Test;

public class TestCookieOrigin {
    @Test
    public void testConstructor() {
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "/", false);
        Assert.assertEquals((Object)"www.apache.org", (Object)origin.getHost());
        Assert.assertEquals((long)80L, (long)origin.getPort());
        Assert.assertEquals((Object)"/", (Object)origin.getPath());
        Assert.assertFalse((boolean)origin.isSecure());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullHost() {
        new CookieOrigin(null, 80, "/", false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyHost() {
        new CookieOrigin("   ", 80, "/", false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativePort() {
        new CookieOrigin("www.apache.org", -80, "/", false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullPath() {
        new CookieOrigin("www.apache.org", 80, null, false);
    }

    @Test
    public void testEmptyPath() {
        CookieOrigin origin = new CookieOrigin("www.apache.org", 80, "", false);
        Assert.assertEquals((Object)"www.apache.org", (Object)origin.getHost());
        Assert.assertEquals((long)80L, (long)origin.getPort());
        Assert.assertEquals((Object)"/", (Object)origin.getPath());
        Assert.assertFalse((boolean)origin.isSecure());
    }
}

