/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStatefulConnManagement
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        this.startServer();
    }

    @Test
    public void testStatefulConnections() throws Exception {
        int workerCount = 5;
        int requestCount = 5;
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        HttpHost target = new HttpHost("localhost", port);
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager();
        mgr.setMaxTotal(5);
        mgr.setDefaultMaxPerRoute(5);
        UserTokenHandler userTokenHandler = new UserTokenHandler(){

            public Object getUserToken(HttpContext context) {
                String id = (String)context.getAttribute("user");
                return id;
            }
        };
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)mgr).setUserTokenHandler(userTokenHandler).build();
        HttpClientContext[] contexts = new HttpClientContext[5];
        HttpWorker[] workers = new HttpWorker[5];
        for (int i = 0; i < contexts.length; ++i) {
            HttpClientContext context;
            contexts[i] = context = HttpClientContext.create();
            workers[i] = new HttpWorker("user" + i, context, 5, target, (HttpClient)this.httpclient);
        }
        for (HttpWorker httpWorker : workers) {
            httpWorker.start();
        }
        for (HttpWorker httpWorker : workers) {
            httpWorker.join(10000L);
        }
        for (HttpWorker httpWorker : workers) {
            Exception ex = httpWorker.getException();
            if (ex != null) {
                throw ex;
            }
            Assert.assertEquals((long)5L, (long)httpWorker.getCount());
        }
        for (HttpWorker httpWorker : contexts) {
            String uid = (String)httpWorker.getAttribute("user");
            for (int r = 0; r < 5; ++r) {
                String state = (String)httpWorker.getAttribute("r" + r);
                Assert.assertNotNull((Object)state);
                Assert.assertEquals((Object)uid, (Object)state);
            }
        }
    }

    @Test
    public void testRouteSpecificPoolRecylcing() throws Exception {
        int maxConn = 2;
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        PoolingHttpClientConnectionManager connMngr = new PoolingHttpClientConnectionManager();
        connMngr.setMaxTotal(2);
        connMngr.setDefaultMaxPerRoute(2);
        UserTokenHandler userTokenHandler = new UserTokenHandler(){

            public Object getUserToken(HttpContext context) {
                return context.getAttribute("user");
            }
        };
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMngr).setUserTokenHandler(userTokenHandler).build();
        BasicHttpContext context1 = new BasicHttpContext();
        context1.setAttribute("user", (Object)"stuff");
        CloseableHttpResponse response1 = this.httpclient.execute(new HttpHost("localhost", port), (HttpRequest)new HttpGet("/"), (HttpContext)context1);
        EntityUtils.consume((HttpEntity)response1.getEntity());
        Thread.sleep(100L);
        BasicHttpContext context2 = new BasicHttpContext();
        CloseableHttpResponse response2 = this.httpclient.execute(new HttpHost("127.0.0.1", port), (HttpRequest)new HttpGet("/"), (HttpContext)context2);
        EntityUtils.consume((HttpEntity)response2.getEntity());
        Thread.sleep(100L);
        BasicHttpContext context3 = new BasicHttpContext();
        CloseableHttpResponse response3 = this.httpclient.execute(new HttpHost("localhost", port), (HttpRequest)new HttpGet("/"), (HttpContext)context3);
        EntityUtils.consume((HttpEntity)response3.getEntity());
    }

    static class HttpWorker
    extends Thread {
        private final String uid;
        private final HttpClientContext context;
        private final int requestCount;
        private final HttpHost target;
        private final HttpClient httpclient;
        private volatile Exception exception;
        private volatile int count;

        public HttpWorker(String uid, HttpClientContext context, int requestCount, HttpHost target, HttpClient httpclient) {
            this.uid = uid;
            this.context = context;
            this.requestCount = requestCount;
            this.target = target;
            this.httpclient = httpclient;
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public Exception getException() {
            return this.exception;
        }

        public void run() {
            try {
                this.context.setAttribute("user", (Object)this.uid);
                for (int r = 0; r < this.requestCount; ++r) {
                    HttpGet httpget = new HttpGet("/");
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)httpget, (HttpContext)this.context);
                    ++this.count;
                    HttpClientConnection conn = (HttpClientConnection)this.context.getConnection(HttpClientConnection.class);
                    HttpContext connContext = (HttpContext)conn;
                    String connuid = (String)connContext.getAttribute("user");
                    if (connuid == null) {
                        connContext.setAttribute("user", (Object)this.uid);
                        connuid = this.uid;
                    }
                    this.context.setAttribute("r" + r, (Object)connuid);
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

