/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestEofSensorInputStream {
    private InputStream inStream;
    private EofSensorWatcher eofwatcher;
    private EofSensorInputStream eofstream;

    @Before
    public void setup() throws Exception {
        this.inStream = (InputStream)Mockito.mock(InputStream.class);
        this.eofwatcher = (EofSensorWatcher)Mockito.mock(EofSensorWatcher.class);
        this.eofstream = new EofSensorInputStream(this.inStream, this.eofwatcher);
    }

    @Test
    public void testClose() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamClosed((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.close();
        Assert.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamClosed(this.inStream);
        this.eofstream.close();
    }

    @Test
    public void testCloseIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamClosed((InputStream)Mockito.any())).thenThrow(new Throwable[]{new IOException()});
        try {
            this.eofstream.close();
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamClosed(this.inStream);
    }

    @Test
    public void testReleaseConnection() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamClosed((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.releaseConnection();
        Assert.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamClosed(this.inStream);
        this.eofstream.releaseConnection();
    }

    @Test
    public void testAbortConnection() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamAbort((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.abortConnection();
        Assert.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
        this.eofstream.abortConnection();
    }

    @Test
    public void testAbortConnectionIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamAbort((InputStream)Mockito.any())).thenThrow(new Throwable[]{new IOException()});
        try {
            this.eofstream.abortConnection();
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
    }

    @Test
    public void testRead() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read()).thenReturn((Object)0, (Object[])new Integer[]{-1});
        Assert.assertEquals((long)0L, (long)this.eofstream.read());
        Assert.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assert.assertNotNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher, (VerificationMode)Mockito.never())).eofDetected(this.inStream);
        Assert.assertEquals((long)-1L, (long)this.eofstream.read());
        Assert.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).eofDetected(this.inStream);
        Assert.assertEquals((long)-1L, (long)this.eofstream.read());
    }

    @Test
    public void testReadIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read()).thenThrow(new Throwable[]{new IOException()});
        try {
            this.eofstream.read();
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
    }

    @Test
    public void testReadByteArray() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)1, (Object[])new Integer[]{-1});
        byte[] tmp = new byte[1];
        Assert.assertEquals((long)1L, (long)this.eofstream.read(tmp));
        Assert.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assert.assertNotNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher, (VerificationMode)Mockito.never())).eofDetected(this.inStream);
        Assert.assertEquals((long)-1L, (long)this.eofstream.read(tmp));
        Assert.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).eofDetected(this.inStream);
        Assert.assertEquals((long)-1L, (long)this.eofstream.read(tmp));
    }

    @Test
    public void testReadByteArrayIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenThrow(new Throwable[]{new IOException()});
        byte[] tmp = new byte[1];
        try {
            this.eofstream.read(tmp);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assert.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
    }

    @Test
    public void testReadAfterAbort() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamAbort((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.abortConnection();
        try {
            this.eofstream.read();
            Assert.fail((String)"IOException expected");
        }
        catch (IOException ex) {
            // empty catch block
        }
        byte[] tmp = new byte[1];
        try {
            this.eofstream.read(tmp);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

