/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.io.HttpDataTransmitter;

public class HttpDataOutputStream
extends OutputStream {
    private final HttpDataTransmitter datatransmitter;
    private boolean closed = false;

    public HttpDataOutputStream(HttpDataTransmitter datatransmitter) {
        if (datatransmitter == null) {
            throw new IllegalArgumentException("HTTP data transmitter may not be null");
        }
        this.datatransmitter = datatransmitter;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.datatransmitter.flush();
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Stream closed");
        }
    }

    public void flush() throws IOException {
        this.assertNotClosed();
        this.datatransmitter.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.assertNotClosed();
        this.datatransmitter.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.assertNotClosed();
        this.datatransmitter.write(b);
    }
}

