/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.LangUtils;

public class BasicHeaderElement
implements HeaderElement {
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    public BasicHeaderElement(NameValuePair[] nvps) {
        if (nvps.length > 0) {
            NameValuePair nvp = nvps[0];
            this.name = nvp.getName();
            this.value = nvp.getValue();
            int len = nvps.length - 1;
            if (len > 0) {
                this.parameters = new NameValuePair[len];
                System.arraycopy(nvps, 1, this.parameters, 0, len);
            } else {
                this.parameters = new NameValuePair[0];
            }
        } else {
            this.name = "";
            this.value = null;
            this.parameters = new NameValuePair[0];
        }
    }

    public BasicHeaderElement(String name, String value, NameValuePair[] parameters) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
        this.parameters = parameters != null ? (NameValuePair[])parameters.clone() : new NameValuePair[0];
    }

    public BasicHeaderElement(String name, String value) {
        this(name, value, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public NameValuePair getParameter(int index) {
        return this.parameters[index];
    }

    public NameValuePair getParameterByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        NameValuePair found = null;
        for (int i = 0; i < this.parameters.length; ++i) {
            NameValuePair current = this.parameters[i];
            if (!current.getName().equalsIgnoreCase(name)) continue;
            found = current;
            break;
        }
        return found;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof HeaderElement) {
            BasicHeaderElement that = (BasicHeaderElement)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value) && LangUtils.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.name);
        hash = LangUtils.hashCode(hash, this.value);
        for (int i = 0; i < this.parameters.length; ++i) {
            hash = LangUtils.hashCode(hash, this.parameters[i]);
        }
        return hash;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(this.name);
        if (this.value != null) {
            buffer.append("=");
            buffer.append(this.value);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            buffer.append("; ");
            buffer.append(this.parameters[i]);
        }
        return buffer.toString();
    }
}

