/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.pool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnection;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.impl.pool.BasicPoolEntry;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.pool.AbstractConnPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static AtomicLong COUNTER = new AtomicLong();
    private final SSLSocketFactory sslfactory;
    private final HttpParams params;

    public BasicConnPool(SSLSocketFactory sslfactory, HttpParams params) {
        super(2, 20);
        if (params == null) {
            throw new IllegalArgumentException("HTTP params may not be null");
        }
        this.sslfactory = sslfactory;
        this.params = params;
    }

    public BasicConnPool(HttpParams params) {
        this(null, params);
    }

    @Override
    protected HttpClientConnection createConnection(HttpHost host) throws IOException {
        DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
        String scheme = host.getSchemeName();
        Socket socket = null;
        if ("http".equalsIgnoreCase(scheme)) {
            socket = new Socket();
        }
        if ("https".equalsIgnoreCase(scheme) && this.sslfactory != null) {
            socket = this.sslfactory.createSocket();
        }
        if (socket == null) {
            throw new IOException(scheme + " scheme is not supported");
        }
        int connectTimeout = HttpConnectionParams.getConnectionTimeout(this.params);
        int soTimeout = HttpConnectionParams.getSoTimeout(this.params);
        socket.setSoTimeout(soTimeout);
        socket.connect(new InetSocketAddress(host.getHostName(), host.getPort()), connectTimeout);
        conn.bind(socket, this.params);
        return conn;
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected void closeEntry(BasicPoolEntry entry) {
        HttpConnection conn = (HttpConnection)entry.getConnection();
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

