/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.impl.nio.codecs.AbstractContentEncoder;
import org.apache.http.impl.nio.reactor.SessionOutputBuffer;
import org.apache.http.util.CharArrayBuffer;

public class ChunkEncoder
extends AbstractContentEncoder {
    private final SessionOutputBuffer outbuf;
    private final CharArrayBuffer lineBuffer;

    public ChunkEncoder(SessionOutputBuffer outbuf) {
        if (outbuf == null) {
            throw new IllegalArgumentException("Session output buffer may not be null");
        }
        this.outbuf = outbuf;
        this.lineBuffer = new CharArrayBuffer(16);
    }

    public int write(ByteBuffer src) throws IOException {
        if (src == null) {
            return 0;
        }
        this.assertNotCompleted();
        int chunk = src.remaining();
        if (chunk == 0) {
            return 0;
        }
        this.lineBuffer.clear();
        this.lineBuffer.append(Integer.toHexString(chunk));
        this.outbuf.writeLine(this.lineBuffer);
        this.outbuf.write(src);
        this.lineBuffer.clear();
        this.outbuf.writeLine(this.lineBuffer);
        return chunk;
    }

    public void complete() throws IOException {
        this.assertNotCompleted();
        this.lineBuffer.clear();
        this.lineBuffer.append("0");
        this.outbuf.writeLine(this.lineBuffer);
        this.lineBuffer.clear();
        this.outbuf.writeLine(this.lineBuffer);
        this.completed = true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[chunk-coded; completed: ");
        buffer.append(this.completed);
        buffer.append("]");
        return buffer.toString();
    }
}

