/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import org.apache.http.HttpResponseFactory;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

@Immutable
public class DefaultClientIOEventDispatch
implements IOEventDispatch {
    protected final ByteBufferAllocator allocator;
    protected final NHttpClientHandler handler;
    protected final HttpParams params;

    public DefaultClientIOEventDispatch(NHttpClientHandler handler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.allocator = this.createByteBufferAllocator();
        this.handler = handler;
        this.params = params;
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return new HeapByteBufferAllocator();
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        try {
            return new DefaultNHttpClientConnection(session, this.createHttpResponseFactory(), this.allocator, this.params);
        }
        catch (RuntimeException ex) {
            session.shutdown();
            throw ex;
        }
    }

    public void connected(IOSession session) {
        try {
            NHttpClientIOTarget conn = this.createConnection(session);
            Object attachment = session.getAttribute("http.session.attachment");
            session.setAttribute("http.connection", conn);
            int timeout = HttpConnectionParams.getSoTimeout((HttpParams)this.params);
            conn.setSocketTimeout(timeout);
            this.handler.connected(conn, attachment);
        }
        catch (RuntimeException ex) {
            session.shutdown();
            throw ex;
        }
    }

    public void disconnected(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        if (conn != null) {
            this.handler.closed(conn);
        }
    }

    private void ensureNotNull(NHttpClientIOTarget conn) {
        if (conn == null) {
            throw new IllegalStateException("HTTP connection is null");
        }
    }

    public void inputReady(IOSession session) {
        try {
            NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
            this.ensureNotNull(conn);
            conn.consumeInput(this.handler);
        }
        catch (RuntimeException ex) {
            session.shutdown();
            throw ex;
        }
    }

    public void outputReady(IOSession session) {
        try {
            NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
            this.ensureNotNull(conn);
            conn.produceOutput(this.handler);
        }
        catch (RuntimeException ex) {
            session.shutdown();
            throw ex;
        }
    }

    public void timeout(IOSession session) {
        try {
            NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
            this.ensureNotNull(conn);
            this.handler.timeout(conn);
        }
        catch (RuntimeException ex) {
            session.shutdown();
            throw ex;
        }
    }
}

