/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;

@NotThreadSafe
public class NStringEntity
extends AbstractHttpEntity
implements ProducingNHttpEntity {
    protected final byte[] content;
    protected final ByteBuffer buffer;

    public static NStringEntity create(String string, ContentType contentType) {
        try {
            return new NStringEntity(string, contentType);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public static NStringEntity create(String string, String charset) {
        return NStringEntity.create(string, ContentType.create((String)"text/plain", (String)charset));
    }

    public static NStringEntity create(String string) {
        return NStringEntity.create(string, ContentType.DEFAULT_TEXT);
    }

    public NStringEntity(String s, ContentType contentType) throws UnsupportedEncodingException {
        String charset;
        if (s == null) {
            throw new IllegalArgumentException("Source string may not be null");
        }
        String string = charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        this.content = s.getBytes(charset);
        this.buffer = ByteBuffer.wrap(this.content);
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NStringEntity(String s, String charset) throws UnsupportedEncodingException {
        this(s, ContentType.create((String)"text/plain", (String)charset));
    }

    public NStringEntity(String s) throws UnsupportedEncodingException {
        this(s, ContentType.DEFAULT_TEXT);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.buffer.limit();
    }

    public void finish() {
        this.buffer.rewind();
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        encoder.write(this.buffer);
        if (!this.buffer.hasRemaining()) {
            encoder.complete();
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outstream.write(this.content);
        outstream.flush();
    }
}

