/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import org.apache.http.HttpRequestFactory;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerIOTarget;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<NHttpServerIOTarget> {
    private final HttpRequestFactory requestFactory;
    private final ByteBufferAllocator allocator;
    private final HttpParams params;

    public DefaultNHttpServerConnectionFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (requestFactory == null) {
            throw new IllegalArgumentException("HTTP request factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.requestFactory = requestFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public DefaultNHttpServerConnectionFactory(HttpParams params) {
        this((HttpRequestFactory)new DefaultHttpRequestFactory(), new HeapByteBufferAllocator(), params);
    }

    protected NHttpServerIOTarget createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    @Override
    public NHttpServerIOTarget createConnection(IOSession session) {
        NHttpServerIOTarget conn = this.createConnection(session, this.requestFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout((HttpParams)this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

