/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.nio.AbstractIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerIOTarget;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultServerIODispatch
extends AbstractIODispatch<NHttpServerIOTarget> {
    private final NHttpServiceHandler handler;
    private final NHttpConnectionFactory<NHttpServerIOTarget> connFactory;

    public DefaultServerIODispatch(NHttpServiceHandler handler, NHttpConnectionFactory<NHttpServerIOTarget> connFactory) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (connFactory == null) {
            throw new IllegalArgumentException("HTTP server connection factory is null");
        }
        this.handler = handler;
        this.connFactory = connFactory;
    }

    public DefaultServerIODispatch(NHttpServiceHandler handler, HttpParams params) {
        this(handler, new DefaultNHttpServerConnectionFactory(params));
    }

    public DefaultServerIODispatch(NHttpServiceHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(handler, new SSLNHttpServerConnectionFactory(sslcontext, sslHandler, params));
    }

    public DefaultServerIODispatch(NHttpServiceHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    @Override
    protected NHttpServerIOTarget createConnection(IOSession session) {
        return this.connFactory.createConnection(session);
    }

    @Override
    protected void onConnected(NHttpServerIOTarget conn) {
        this.handler.connected(conn);
    }

    @Override
    protected void onClosed(NHttpServerIOTarget conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(NHttpServerIOTarget conn, IOException ex) {
        this.handler.exception((NHttpServerConnection)conn, ex);
    }

    @Override
    protected void onInputReady(NHttpServerIOTarget conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(NHttpServerIOTarget conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(NHttpServerIOTarget conn) {
        this.handler.timeout(conn);
    }
}

