/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractAsyncRequestConsumer<T>
implements HttpAsyncRequestConsumer<T> {
    private volatile boolean completed;
    private volatile T result;
    private volatile Exception ex;

    protected abstract void onRequestReceived(HttpRequest var1);

    protected abstract void onContentReceived(ContentDecoder var1, IOControl var2) throws IOException;

    protected abstract T buildResult(HttpContext var1) throws Exception;

    protected abstract void releaseResources();

    @Override
    public synchronized void requestReceived(HttpRequest request) {
        this.onRequestReceived(request);
    }

    @Override
    public synchronized void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.onContentReceived(decoder, ioctrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void requestCompleted(HttpContext context) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        try {
            this.result = this.buildResult(context);
        }
        catch (Exception ex) {
            this.ex = ex;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.releaseResources();
    }

    @Override
    public Exception getException() {
        return this.ex;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }
}

