/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncResponseTrigger;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class BufferingAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;
    private final HttpResponseFactory responseFactory;
    private final ByteBufferAllocator allocator;

    public BufferingAsyncRequestHandler(HttpRequestHandler handler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator) {
        if (handler == null) {
            throw new IllegalArgumentException("Request handler may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        this.handler = handler;
        this.responseFactory = responseFactory;
        this.allocator = allocator;
    }

    public BufferingAsyncRequestHandler(HttpRequestHandler handler) {
        this(handler, (HttpResponseFactory)new DefaultHttpResponseFactory(), new HeapByteBufferAllocator());
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer(this.allocator);
    }

    @Override
    public Cancellable handle(HttpRequest request, HttpAsyncResponseTrigger trigger, HttpContext context) throws HttpException, IOException {
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 200, context);
        this.handler.handle(request, response, context);
        trigger.submitResponse(new BasicAsyncResponseProducer(response));
        return null;
    }
}

