/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

class ErrorResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpVersion version;
    private final int status;
    private final ProducingNHttpEntity entity;
    private final boolean keepAlive;

    ErrorResponseProducer(HttpVersion version, int status, ProducingNHttpEntity entity, boolean keepAlive) {
        this.version = version;
        this.status = status;
        this.entity = entity;
        this.keepAlive = keepAlive;
    }

    public HttpResponse generateResponse() {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)this.version, this.status, EnglishReasonPhraseCatalog.INSTANCE.getReason(this.status, Locale.US));
        if (this.keepAlive) {
            response.addHeader("Connection", "Keep-Alive");
        } else {
            response.addHeader("Connection", "Close");
        }
        response.setEntity((HttpEntity)this.entity);
        return response;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.entity.produceContent(encoder, ioctrl);
    }

    public void responseCompleted(HttpContext context) {
    }

    public void close() throws IOException {
        this.entity.finish();
    }
}

