/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import org.apache.http.nio.protocol.MessageState;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class HttpAsyncClientProtocolHandler
implements NHttpClientHandler {
    public static final String HTTP_HANDLER = "http.nio.exchange-handler";
    static final String HTTP_EXCHANGE = "http.nio.exchange";

    @Override
    public void connected(NHttpClientConnection conn, Object attachment) {
        HttpExchange httpexchange = new HttpExchange();
        HttpContext context = conn.getContext();
        context.setAttribute(HTTP_EXCHANGE, (Object)httpexchange);
        this.requestReady(conn);
    }

    @Override
    public void closed(NHttpClientConnection conn) {
        HttpExchange httpexchange = this.getHttpExchange(conn);
        if (httpexchange != null) {
            httpexchange.clear();
        }
    }

    @Override
    public void exception(NHttpClientConnection conn, HttpException ex) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        HttpAsyncClientExchangeHandler<?> handler = httpexchange.getHandler();
        if (handler != null) {
            handler.failed((Exception)((Object)ex));
        }
        this.closeConnection(conn);
    }

    @Override
    public void exception(NHttpClientConnection conn, IOException ex) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        HttpAsyncClientExchangeHandler<?> handler = httpexchange.getHandler();
        if (handler != null) {
            handler.failed(ex);
        }
        this.shutdownConnection(conn);
    }

    @Override
    public void requestReady(NHttpClientConnection conn) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        if (httpexchange.getRequestState() != MessageState.READY) {
            return;
        }
        HttpAsyncClientExchangeHandler handler = httpexchange.getHandler();
        if (handler != null && handler.isDone()) {
            httpexchange.clear();
            handler = null;
        }
        if (handler == null) {
            handler = (HttpAsyncClientExchangeHandler)conn.getContext().removeAttribute(HTTP_HANDLER);
            httpexchange.setHandler(handler);
        }
        if (handler == null) {
            return;
        }
        try {
            HttpContext context = handler.getContext();
            HttpRequest request = handler.generateRequest();
            httpexchange.setRequest(request);
            conn.submitRequest(request);
            if (request instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                    int timeout = conn.getSocketTimeout();
                    httpexchange.setTimeout(timeout);
                    timeout = request.getParams().getIntParameter("http.protocol.wait-for-continue", 3000);
                    conn.setSocketTimeout(timeout);
                    httpexchange.setRequestState(MessageState.ACK_EXPECTED);
                } else {
                    httpexchange.setRequestState(MessageState.BODY_STREAM);
                }
            } else {
                handler.requestCompleted(context);
                httpexchange.setRequestState(MessageState.COMPLETED);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            this.onException(ex);
        }
    }

    @Override
    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        HttpAsyncClientExchangeHandler<?> handler = this.ensureNotNull(httpexchange.getHandler());
        try {
            if (httpexchange.getRequestState() == MessageState.ACK_EXPECTED) {
                conn.suspendOutput();
                return;
            }
            HttpContext context = handler.getContext();
            handler.produceContent(encoder, conn);
            httpexchange.setRequestState(MessageState.BODY_STREAM);
            if (encoder.isCompleted()) {
                handler.requestCompleted(context);
                httpexchange.setRequestState(MessageState.COMPLETED);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            this.onException(ex);
        }
    }

    @Override
    public void responseReceived(NHttpClientConnection conn) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        HttpAsyncClientExchangeHandler<?> handler = this.ensureNotNull(httpexchange.getHandler());
        try {
            HttpResponse response = conn.getHttpResponse();
            HttpRequest request = httpexchange.getRequest();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200) {
                if (statusCode != 100) {
                    throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                }
                if (httpexchange.getRequestState() == MessageState.ACK_EXPECTED) {
                    int timeout = httpexchange.getTimeout();
                    conn.setSocketTimeout(timeout);
                    conn.requestOutput();
                    httpexchange.setRequestState(MessageState.ACK);
                }
                return;
            }
            httpexchange.setResponse(response);
            if (httpexchange.getRequestState() == MessageState.ACK_EXPECTED) {
                int timeout = httpexchange.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.resetOutput();
                httpexchange.setRequestState(MessageState.COMPLETED);
            } else if (httpexchange.getRequestState() == MessageState.BODY_STREAM) {
                conn.resetOutput();
                conn.suspendOutput();
                httpexchange.setRequestState(MessageState.COMPLETED);
                httpexchange.invalidate();
            }
            handler.responseReceived(response);
            httpexchange.setResponseState(MessageState.BODY_STREAM);
            if (!this.canResponseHaveBody(request, response)) {
                conn.resetInput();
                this.processResponse(conn, httpexchange, handler);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            this.onException(ex);
        }
    }

    @Override
    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        HttpAsyncClientExchangeHandler<?> handler = this.ensureNotNull(httpexchange.getHandler());
        try {
            handler.consumeContent(decoder, conn);
            httpexchange.setResponseState(MessageState.BODY_STREAM);
            if (decoder.isCompleted()) {
                this.processResponse(conn, httpexchange, handler);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            this.onException(ex);
        }
    }

    @Override
    public void timeout(NHttpClientConnection conn) {
        HttpExchange httpexchange = this.ensureNotNull(this.getHttpExchange(conn));
        HttpAsyncClientExchangeHandler<?> handler = httpexchange.getHandler();
        if (handler == null) {
            this.shutdownConnection(conn);
            return;
        }
        try {
            if (httpexchange.getRequestState() == MessageState.ACK_EXPECTED) {
                int timeout = httpexchange.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.requestOutput();
                httpexchange.setRequestState(MessageState.BODY_STREAM);
            } else {
                handler.failed(new SocketTimeoutException());
                if (conn.getStatus() == 0) {
                    this.closeConnection(conn);
                    if (conn.getStatus() == 1) {
                        conn.setSocketTimeout(250);
                    }
                } else {
                    this.shutdownConnection(conn);
                }
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            handler.failed(ex);
            throw ex;
        }
    }

    protected void onException(Exception ex) {
    }

    private void closeConnection(NHttpConnection conn) {
        try {
            conn.close();
        }
        catch (IOException ex) {
            this.onException(ex);
        }
    }

    private void shutdownConnection(NHttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException ex) {
            this.onException(ex);
        }
    }

    private HttpExchange getHttpExchange(NHttpConnection conn) {
        return (HttpExchange)conn.getContext().getAttribute(HTTP_EXCHANGE);
    }

    private HttpExchange ensureNotNull(HttpExchange httpExchange) {
        if (httpExchange == null) {
            throw new IllegalStateException("HTTP exchange is null");
        }
        return httpExchange;
    }

    private HttpAsyncClientExchangeHandler<?> ensureNotNull(HttpAsyncClientExchangeHandler<?> handler) {
        if (handler == null) {
            throw new IllegalStateException("HTTP exchange handler is null");
        }
        return handler;
    }

    private void processResponse(NHttpClientConnection conn, HttpExchange httpexchange, HttpAsyncClientExchangeHandler<?> handler) throws IOException {
        HttpContext context = handler.getContext();
        if (httpexchange.isValid()) {
            ConnectionReuseStrategy connReuseStrategy;
            HttpRequest request = httpexchange.getRequest();
            HttpResponse response = httpexchange.getResponse();
            String method = request.getRequestLine().getMethod();
            int status = response.getStatusLine().getStatusCode();
            if (!(method.equalsIgnoreCase("CONNECT") && status < 300 || (connReuseStrategy = handler.getConnectionReuseStrategy()).keepAlive(response, context))) {
                conn.close();
            }
        } else {
            conn.close();
        }
        handler.responseCompleted(context);
        httpexchange.reset();
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        String method = request.getRequestLine().getMethod();
        int status = response.getStatusLine().getStatusCode();
        if (method.equalsIgnoreCase("HEAD")) {
            return false;
        }
        if (method.equalsIgnoreCase("CONNECT") && status < 300) {
            return false;
        }
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpExchange {
        private volatile HttpAsyncClientExchangeHandler<?> handler;
        private volatile MessageState requestState = MessageState.READY;
        private volatile MessageState responseState = MessageState.READY;
        private volatile HttpRequest request;
        private volatile HttpResponse response;
        private volatile boolean valid = true;
        private volatile int timeout;

        HttpExchange() {
        }

        public HttpAsyncClientExchangeHandler<?> getHandler() {
            return this.handler;
        }

        public void setHandler(HttpAsyncClientExchangeHandler<?> handler) {
            if (this.handler != null) {
                throw new IllegalStateException("Handler already set");
            }
            this.handler = handler;
        }

        public MessageState getRequestState() {
            return this.requestState;
        }

        public void setRequestState(MessageState state) {
            this.requestState = state;
        }

        public MessageState getResponseState() {
            return this.responseState;
        }

        public void setResponseState(MessageState state) {
            this.responseState = state;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            if (this.request != null) {
                throw new IllegalStateException("Request already set");
            }
            this.request = request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            if (this.response != null) {
                throw new IllegalStateException("Response already set");
            }
            this.response = response;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void clear() {
            if (this.handler != null) {
                try {
                    this.handler.close();
                }
                catch (IOException ex) {
                    HttpAsyncClientProtocolHandler.this.onException(ex);
                }
                this.handler = null;
            }
            this.reset();
        }

        public void reset() {
            this.responseState = MessageState.READY;
            this.requestState = MessageState.READY;
            this.response = null;
            this.request = null;
            this.timeout = 0;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void invalidate() {
            this.valid = false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("request state: ");
            buf.append((Object)this.requestState);
            buf.append("; request: ");
            if (this.request != null) {
                buf.append(this.request.getRequestLine());
            }
            buf.append("; response state: ");
            buf.append((Object)this.responseState);
            buf.append("; response: ");
            if (this.response != null) {
                buf.append(this.response.getStatusLine());
            }
            buf.append("; valid: ");
            buf.append(this.valid);
            buf.append(";");
            return buf.toString();
        }
    }
}

