/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.annotation.Immutable;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.ErrorResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncContinueTrigger;
import org.apache.http.nio.protocol.HttpAsyncExpectationVerifier;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseTrigger;
import org.apache.http.nio.protocol.MessageState;
import org.apache.http.nio.protocol.NullRequestHandler;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class HttpAsyncServiceHandler
implements NHttpServiceHandler {
    static final String HTTP_EXCHANGE = "http.nio.http-exchange";
    private final HttpAsyncRequestHandlerResolver handlerResolver;
    private final HttpAsyncExpectationVerifier expectationVerifier;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpParams params;

    public HttpAsyncServiceHandler(HttpAsyncRequestHandlerResolver handlerResolver, HttpAsyncExpectationVerifier expectationVerifier, HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpParams params) {
        if (handlerResolver == null) {
            throw new IllegalArgumentException("Handler resolver may not be null.");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handlerResolver = handlerResolver;
        this.expectationVerifier = expectationVerifier;
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.params = params;
    }

    public HttpAsyncServiceHandler(HttpAsyncRequestHandlerResolver handlerResolver, HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpParams params) {
        this(handlerResolver, null, httpProcessor, connStrategy, params);
    }

    @Override
    public void connected(NHttpServerConnection conn) {
        HttpExchange httpExchange = new HttpExchange();
        conn.getContext().setAttribute(HTTP_EXCHANGE, (Object)httpExchange);
    }

    @Override
    public void closed(NHttpServerConnection conn) {
        HttpExchange httpExchange = this.ensureNotNull(this.getHttpExchange(conn));
        Cancellable asyncProcess = httpExchange.getAsyncProcess();
        httpExchange.clear();
        if (asyncProcess != null) {
            asyncProcess.cancel();
        }
    }

    @Override
    public void exception(NHttpServerConnection conn, HttpException httpex) {
        if (conn.isResponseSubmitted()) {
            this.closeConnection(conn);
            this.onException((Exception)((Object)httpex));
            return;
        }
        HttpExchange httpExchange = this.ensureNotNull(this.getHttpExchange(conn));
        try {
            HttpAsyncResponseProducer responseProducer = this.handleException((Exception)((Object)httpex));
            httpExchange.setResponseProducer(responseProducer);
            this.commitResponse(conn, httpExchange);
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            this.onException(ex);
        }
    }

    @Override
    public void exception(NHttpServerConnection conn, IOException ex) {
        this.shutdownConnection(conn);
        this.onException(ex);
    }

    @Override
    public void requestReceived(NHttpServerConnection conn) {
        HttpExchange httpExchange = this.ensureNotNull(this.getHttpExchange(conn));
        try {
            HttpRequest request = conn.getHttpRequest();
            HttpContext context = httpExchange.getContext();
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
            context.setAttribute("http.request", (Object)request);
            context.setAttribute("http.connection", (Object)conn);
            this.httpProcessor.process(request, context);
            httpExchange.setRequest(request);
            HttpAsyncRequestHandler<Object> requestHandler = this.getRequestHandler(request);
            httpExchange.setRequestHandler(requestHandler);
            HttpAsyncRequestConsumer<Object> consumer = requestHandler.processRequest(request, context);
            httpExchange.setRequestConsumer(consumer);
            consumer.requestReceived(request);
            if (request instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                    httpExchange.setRequestState(MessageState.ACK_EXPECTED);
                    if (this.expectationVerifier != null) {
                        conn.suspendInput();
                        ContinueTriggerImpl trigger = new ContinueTriggerImpl(httpExchange, conn);
                        Cancellable asyncProcess = this.expectationVerifier.verify(request, trigger, context);
                        httpExchange.setAsyncProcess(asyncProcess);
                    } else {
                        HttpResponse response = this.create100Continue(request);
                        conn.submitResponse(response);
                        httpExchange.setRequestState(MessageState.BODY_STREAM);
                    }
                } else {
                    httpExchange.setRequestState(MessageState.BODY_STREAM);
                }
            } else {
                conn.suspendInput();
                this.processRequest(conn, httpExchange);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            this.onException(ex);
        }
    }

    @Override
    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        HttpExchange httpExchange = this.ensureNotNull(this.getHttpExchange(conn));
        try {
            HttpAsyncRequestConsumer<Object> consumer = this.ensureNotNull(httpExchange.getRequestConsumer());
            consumer.consumeContent(decoder, conn);
            httpExchange.setRequestState(MessageState.BODY_STREAM);
            if (decoder.isCompleted()) {
                conn.suspendInput();
                this.processRequest(conn, httpExchange);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            this.onException(ex);
        }
    }

    @Override
    public void responseReady(NHttpServerConnection conn) {
        HttpExchange httpExchange = this.ensureNotNull(this.getHttpExchange(conn));
        try {
            if (httpExchange.getRequestState() == MessageState.ACK) {
                conn.requestInput();
                httpExchange.setRequestState(MessageState.BODY_STREAM);
                HttpRequest request = httpExchange.getRequest();
                HttpResponse response = this.create100Continue(request);
                conn.submitResponse(response);
            } else if (httpExchange.getResponse() == null && httpExchange.getResponseProducer() != null) {
                if (httpExchange.getRequestState() == MessageState.ACK_EXPECTED) {
                    conn.resetInput();
                    httpExchange.setRequestState(MessageState.COMPLETED);
                }
                this.commitResponse(conn, httpExchange);
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            this.onException(ex);
        }
    }

    @Override
    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        HttpExchange httpExchange = this.ensureNotNull(this.getHttpExchange(conn));
        try {
            HttpAsyncResponseProducer responseProducer = httpExchange.getResponseProducer();
            HttpContext context = httpExchange.getContext();
            HttpResponse response = httpExchange.getResponse();
            responseProducer.produceContent(encoder, conn);
            httpExchange.setResponseState(MessageState.BODY_STREAM);
            if (encoder.isCompleted()) {
                responseProducer.responseCompleted(context);
                if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                } else {
                    conn.requestInput();
                }
                httpExchange.clear();
            }
        }
        catch (RuntimeException ex) {
            this.shutdownConnection(conn);
            throw ex;
        }
        catch (Exception ex) {
            this.shutdownConnection(conn);
            this.onException(ex);
        }
    }

    @Override
    public void timeout(NHttpServerConnection conn) {
        try {
            if (conn.getStatus() == 0) {
                conn.close();
                if (conn.getStatus() == 1) {
                    conn.setSocketTimeout(250);
                }
            } else {
                conn.shutdown();
            }
        }
        catch (IOException ex) {
            this.onException(ex);
        }
    }

    private HttpExchange getHttpExchange(NHttpConnection conn) {
        return (HttpExchange)conn.getContext().getAttribute(HTTP_EXCHANGE);
    }

    private HttpExchange ensureNotNull(HttpExchange httpExchange) {
        if (httpExchange == null) {
            throw new IllegalStateException("HTTP exchange is null");
        }
        return httpExchange;
    }

    private HttpAsyncRequestConsumer<Object> ensureNotNull(HttpAsyncRequestConsumer<Object> requestConsumer) {
        if (requestConsumer == null) {
            throw new IllegalStateException("Request consumer is null");
        }
        return requestConsumer;
    }

    protected void onException(Exception ex) {
    }

    private void closeConnection(NHttpConnection conn) {
        try {
            conn.close();
        }
        catch (IOException ex) {
            this.onException(ex);
        }
    }

    private void shutdownConnection(NHttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException ex) {
            this.onException(ex);
        }
    }

    protected HttpAsyncResponseProducer handleException(Exception ex) {
        int code = 500;
        if (ex instanceof MethodNotSupportedException) {
            code = 501;
        } else if (ex instanceof UnsupportedHttpVersionException) {
            code = 505;
        } else if (ex instanceof ProtocolException) {
            code = 400;
        }
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        return new ErrorResponseProducer(HttpVersion.HTTP_1_0, code, NStringEntity.create(message), false);
    }

    private HttpResponse create100Continue(HttpRequest request) {
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        return new BasicHttpResponse(ver, 100, "Continue");
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private void processRequest(NHttpServerConnection conn, HttpExchange httpExchange) throws HttpException, IOException {
        HttpAsyncRequestHandler<Object> handler = httpExchange.getRequestHandler();
        HttpContext context = httpExchange.getContext();
        HttpAsyncRequestConsumer<Object> consumer = httpExchange.getRequestConsumer();
        consumer.requestCompleted(context);
        httpExchange.setRequestState(MessageState.COMPLETED);
        Exception exception = consumer.getException();
        if (exception != null) {
            HttpAsyncResponseProducer responseProducer = this.handleException(exception);
            httpExchange.setResponseProducer(responseProducer);
            conn.requestOutput();
        } else {
            Object result = consumer.getResult();
            ResponseTriggerImpl trigger = new ResponseTriggerImpl(httpExchange, conn);
            try {
                Cancellable asyncProcess = handler.handle(result, trigger, context);
                httpExchange.setAsyncProcess(asyncProcess);
            }
            catch (HttpException ex) {
                HttpAsyncResponseProducer responseProducer = this.handleException((Exception)((Object)ex));
                httpExchange.setResponseProducer(responseProducer);
                conn.requestOutput();
            }
        }
    }

    private void commitResponse(NHttpServerConnection conn, HttpExchange httpExchange) throws IOException, HttpException {
        HttpContext context = httpExchange.getContext();
        HttpRequest request = httpExchange.getRequest();
        HttpAsyncResponseProducer responseProducer = httpExchange.getResponseProducer();
        HttpResponse response = responseProducer.generateResponse();
        response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.params));
        httpExchange.setResponse(response);
        context.setAttribute("http.response", (Object)response);
        this.httpProcessor.process(response, context);
        HttpEntity entity = response.getEntity();
        if (entity != null && !this.canResponseHaveBody(request, response)) {
            response.setEntity(null);
            entity = null;
        }
        conn.submitResponse(response);
        if (entity == null) {
            responseProducer.responseCompleted(context);
            if (!this.connStrategy.keepAlive(response, context)) {
                conn.close();
            } else {
                conn.requestInput();
            }
            httpExchange.clear();
        } else {
            httpExchange.setResponseState(MessageState.BODY_STREAM);
        }
    }

    private HttpAsyncRequestHandler<Object> getRequestHandler(HttpRequest request) {
        HttpAsyncRequestHandler<Object> handler = null;
        if (this.handlerResolver != null) {
            String requestURI = request.getRequestLine().getUri();
            handler = this.handlerResolver.lookup(requestURI);
        }
        if (handler == null) {
            handler = new NullRequestHandler();
        }
        return handler;
    }

    class ContinueTriggerImpl
    implements HttpAsyncContinueTrigger {
        private final HttpExchange httpExchange;
        private final IOControl iocontrol;
        private volatile boolean triggered;

        public ContinueTriggerImpl(HttpExchange httpExchange, IOControl iocontrol) {
            this.httpExchange = httpExchange;
            this.iocontrol = iocontrol;
        }

        public synchronized void continueRequest() {
            if (this.triggered) {
                throw new IllegalStateException("Response already triggered");
            }
            this.triggered = true;
            this.httpExchange.setRequestState(MessageState.ACK);
            this.iocontrol.requestOutput();
        }

        public synchronized void submitResponse(HttpAsyncResponseProducer responseProducer) {
            if (responseProducer == null) {
                throw new IllegalArgumentException("Response producer may not be null");
            }
            if (this.triggered) {
                throw new IllegalStateException("Response already triggered");
            }
            this.triggered = true;
            this.httpExchange.setResponseProducer(responseProducer);
            this.iocontrol.requestOutput();
        }

        public boolean isTriggered() {
            return this.triggered;
        }
    }

    class ResponseTriggerImpl
    implements HttpAsyncResponseTrigger {
        private final HttpExchange httpExchange;
        private final IOControl iocontrol;
        private volatile boolean triggered;

        public ResponseTriggerImpl(HttpExchange httpExchange, IOControl iocontrol) {
            this.httpExchange = httpExchange;
            this.iocontrol = iocontrol;
        }

        public synchronized void submitResponse(HttpAsyncResponseProducer responseProducer) {
            if (responseProducer == null) {
                throw new IllegalArgumentException("Response producer may not be null");
            }
            if (this.triggered) {
                throw new IllegalStateException("Response already triggered");
            }
            this.triggered = true;
            this.httpExchange.setResponseProducer(responseProducer);
            this.iocontrol.requestOutput();
        }

        public boolean isTriggered() {
            return this.triggered;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpExchange {
        private final BasicHttpContext context = new BasicHttpContext();
        private volatile HttpAsyncRequestHandler<Object> requestHandler;
        private volatile MessageState requestState = MessageState.READY;
        private volatile MessageState responseState = MessageState.READY;
        private volatile HttpAsyncRequestConsumer<Object> requestConsumer;
        private volatile HttpAsyncResponseProducer responseProducer;
        private volatile HttpRequest request;
        private volatile HttpResponse response;
        private volatile Cancellable asyncProcess;

        HttpExchange() {
        }

        public HttpContext getContext() {
            return this.context;
        }

        public HttpAsyncRequestHandler<Object> getRequestHandler() {
            return this.requestHandler;
        }

        public void setRequestHandler(HttpAsyncRequestHandler<Object> requestHandler) {
            if (this.requestHandler != null) {
                throw new IllegalStateException("Request handler already set");
            }
            this.requestHandler = requestHandler;
        }

        public MessageState getRequestState() {
            return this.requestState;
        }

        public void setRequestState(MessageState state) {
            this.requestState = state;
        }

        public MessageState getResponseState() {
            return this.responseState;
        }

        public void setResponseState(MessageState state) {
            this.responseState = state;
        }

        public HttpAsyncRequestConsumer<Object> getRequestConsumer() {
            return this.requestConsumer;
        }

        public void setRequestConsumer(HttpAsyncRequestConsumer<Object> requestConsumer) {
            if (this.requestConsumer != null) {
                throw new IllegalStateException("Request consumer already set");
            }
            this.requestConsumer = requestConsumer;
        }

        public HttpAsyncResponseProducer getResponseProducer() {
            return this.responseProducer;
        }

        public void setResponseProducer(HttpAsyncResponseProducer responseProducer) {
            if (this.responseProducer != null) {
                throw new IllegalStateException("Response producer already set");
            }
            this.responseProducer = responseProducer;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            if (this.request != null) {
                throw new IllegalStateException("Request already set");
            }
            this.request = request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            if (this.response != null) {
                throw new IllegalStateException("Response already set");
            }
            this.response = response;
        }

        public Cancellable getAsyncProcess() {
            return this.asyncProcess;
        }

        public void setAsyncProcess(Cancellable asyncProcess) {
            this.asyncProcess = asyncProcess;
        }

        public void clear() {
            this.responseState = MessageState.READY;
            this.requestState = MessageState.READY;
            this.requestHandler = null;
            if (this.requestConsumer != null) {
                try {
                    this.requestConsumer.close();
                }
                catch (IOException ex) {
                    HttpAsyncServiceHandler.this.onException(ex);
                }
            }
            this.requestConsumer = null;
            if (this.responseProducer != null) {
                try {
                    this.responseProducer.close();
                }
                catch (IOException ex) {
                    HttpAsyncServiceHandler.this.onException(ex);
                }
            }
            this.responseProducer = null;
            this.request = null;
            this.response = null;
            this.asyncProcess = null;
            this.context.clear();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("request state: ");
            buf.append((Object)this.requestState);
            buf.append("; request: ");
            if (this.request != null) {
                buf.append(this.request.getRequestLine());
            }
            buf.append("; response state: ");
            buf.append((Object)this.responseState);
            buf.append("; response: ");
            if (this.response != null) {
                buf.append(this.response.getStatusLine());
            }
            buf.append(";");
            return buf.toString();
        }
    }
}

