/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.pool;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.pool.LeaseRequest;
import org.apache.http.nio.pool.NIOConnFactory;
import org.apache.http.nio.pool.RouteSpecificPool;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.pool.ConnPool;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractNIOConnPool<T, C, E extends PoolEntry<T, C>>
implements ConnPool<T, E>,
ConnPoolControl<T> {
    private final ConnectingIOReactor ioreactor;
    private final NIOConnFactory<T, C> connFactory;
    private final SessionRequestCallback sessionRequestCallback;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final LinkedList<LeaseRequest<T, C, E>> leasingRequests;
    private final Set<SessionRequest> pending;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final Map<T, Integer> maxPerRoute;
    private final Lock lock;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;

    public AbstractNIOConnPool(ConnectingIOReactor ioreactor, NIOConnFactory<T, C> connFactory, int defaultMaxPerRoute, int maxTotal) {
        if (ioreactor == null) {
            throw new IllegalArgumentException("I/O reactor may not be null");
        }
        if (connFactory == null) {
            throw new IllegalArgumentException("Connection factory may not null");
        }
        if (defaultMaxPerRoute <= 0) {
            throw new IllegalArgumentException("Max per route value may not be negative or zero");
        }
        if (maxTotal <= 0) {
            throw new IllegalArgumentException("Max total value may not be negative or zero");
        }
        this.ioreactor = ioreactor;
        this.connFactory = connFactory;
        this.sessionRequestCallback = new InternalSessionRequestCallback();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leasingRequests = new LinkedList();
        this.pending = new HashSet<SessionRequest>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
        this.lock = new ReentrantLock();
        this.defaultMaxPerRoute = defaultMaxPerRoute;
        this.maxTotal = maxTotal;
    }

    protected abstract SocketAddress resolveRemoteAddress(T var1);

    protected abstract SocketAddress resolveLocalAddress(T var1);

    protected abstract E createEntry(T var1, C var2);

    public boolean isShutdown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long waitMs) throws IOException {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (SessionRequest sessionRequest : this.pending) {
                sessionRequest.cancel();
            }
            for (PoolEntry poolEntry : this.available) {
                poolEntry.close();
            }
            for (PoolEntry poolEntry : this.leased) {
                poolEntry.close();
            }
            for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                routeSpecificPool.shutdown();
            }
            this.routeToPool.clear();
            this.leased.clear();
            this.pending.clear();
            this.available.clear();
            this.leasingRequests.clear();
            this.ioreactor.shutdown(waitMs);
        }
        finally {
            this.lock.unlock();
        }
    }

    private RouteSpecificPool<T, C, E> getPool(T route) {
        RouteSpecificPool pool = this.routeToPool.get(route);
        if (pool == null) {
            pool = new RouteSpecificPool<T, C, E>(route){

                @Override
                protected E createEntry(T route, C conn) {
                    return AbstractNIOConnPool.this.createEntry(route, conn);
                }
            };
            this.routeToPool.put(route, pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<E> lease(T route, Object state, long connectTimeout, TimeUnit tunit, FutureCallback<E> callback) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null.");
        }
        if (this.isShutDown) {
            throw new IllegalStateException("Session pool has been shut down");
        }
        this.lock.lock();
        try {
            long timeout = connectTimeout > 0L ? tunit.toMillis(connectTimeout) : 0L;
            BasicFuture future = new BasicFuture(callback);
            LeaseRequest request = new LeaseRequest(route, state, timeout, future);
            boolean completed = this.processPendingRequest(request);
            if (!request.isDone() && !completed) {
                this.leasingRequests.add(request);
            }
            BasicFuture basicFuture = future;
            return basicFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Future<E> lease(T route, Object state, FutureCallback<E> callback) {
        return this.lease(route, state, -1L, TimeUnit.MICROSECONDS, callback);
    }

    public Future<E> lease(T route, Object state) {
        return this.lease(route, state, -1L, TimeUnit.MICROSECONDS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(E entry, boolean reusable) {
        if (entry == null) {
            return;
        }
        if (this.isShutDown) {
            return;
        }
        this.lock.lock();
        try {
            if (this.leased.remove(entry)) {
                RouteSpecificPool<Object, C, E> pool = this.getPool(entry.getRoute());
                pool.free(entry, reusable);
                if (reusable) {
                    this.available.addFirst(entry);
                } else {
                    entry.close();
                }
                this.processNextPendingRequest();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processPendingRequests() {
        ListIterator it = this.leasingRequests.listIterator();
        while (it.hasNext()) {
            LeaseRequest request = (LeaseRequest)it.next();
            boolean completed = this.processPendingRequest(request);
            if (!request.isDone() && !completed) continue;
            it.remove();
        }
    }

    private void processNextPendingRequest() {
        ListIterator it = this.leasingRequests.listIterator();
        while (it.hasNext()) {
            LeaseRequest request = (LeaseRequest)it.next();
            boolean completed = this.processPendingRequest(request);
            if (request.isDone() || completed) {
                it.remove();
            }
            if (!completed) continue;
            return;
        }
    }

    private boolean processPendingRequest(LeaseRequest<T, C, E> request) {
        T route = request.getRoute();
        Object state = request.getState();
        long deadline = request.getDeadline();
        BasicFuture<E> future = request.getFuture();
        long now = System.currentTimeMillis();
        if (now > deadline) {
            future.failed((Exception)new TimeoutException());
            return false;
        }
        RouteSpecificPool<T, C, E> pool = this.getPool(route);
        Object entry = null;
        while ((entry = (Object)pool.getFree(state)) != null && (entry.isClosed() || entry.isExpired(System.currentTimeMillis()))) {
            entry.close();
            this.available.remove(entry);
            pool.free(entry, false);
        }
        if (entry != null) {
            this.available.remove(entry);
            this.leased.add(entry);
            future.completed(entry);
            return true;
        }
        int maxPerRoute = this.getMax(route);
        int excess = Math.max(0, pool.getAllocatedCount() + 1 - maxPerRoute);
        if (excess > 0) {
            E lastUsed;
            for (int i = 0; i < excess && (lastUsed = pool.getLastUsed()) != null; ++i) {
                lastUsed.close();
                this.available.remove(lastUsed);
                pool.remove(lastUsed);
            }
        }
        if (pool.getAllocatedCount() < maxPerRoute) {
            int totalUsed = this.pending.size() + this.leased.size();
            int freeCapacity = Math.max(this.maxTotal - totalUsed, 0);
            if (freeCapacity == 0) {
                return false;
            }
            int totalAvailable = this.available.size();
            if (totalAvailable > freeCapacity - 1 && !this.available.isEmpty()) {
                PoolEntry lastUsed = (PoolEntry)this.available.removeLast();
                lastUsed.close();
                RouteSpecificPool<Object, C, PoolEntry> otherpool = this.getPool(lastUsed.getRoute());
                otherpool.remove(lastUsed);
            }
            SessionRequest sessionRequest = this.ioreactor.connect(this.resolveRemoteAddress(route), this.resolveLocalAddress(route), route, this.sessionRequestCallback);
            int timout = request.getConnectTimeout() < Integer.MAX_VALUE ? (int)request.getConnectTimeout() : Integer.MAX_VALUE;
            sessionRequest.setConnectTimeout(timout);
            this.pending.add(sessionRequest);
            pool.addPending(sessionRequest, future);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePendingRequests() {
        this.lock.lock();
        try {
            long now = System.currentTimeMillis();
            ListIterator it = this.leasingRequests.listIterator();
            while (it.hasNext()) {
                LeaseRequest request = (LeaseRequest)it.next();
                long deadline = request.getDeadline();
                if (now <= deadline) continue;
                it.remove();
                BasicFuture future = request.getFuture();
                future.failed((Exception)new TimeoutException());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCompleted(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(request);
            RouteSpecificPool<Object, C, E> pool = this.getPool(route);
            IOSession session = request.getSession();
            try {
                C conn = this.connFactory.create(route, session);
                E entry = pool.createEntry(request, conn);
                this.leased.add(entry);
                pool.completed(request, entry);
            }
            catch (IOException ex) {
                pool.failed(request, ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCancelled(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(request);
            RouteSpecificPool<Object, C, E> pool = this.getPool(route);
            pool.cancelled(request);
            this.processNextPendingRequest();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailed(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(request);
            RouteSpecificPool<Object, C, E> pool = this.getPool(route);
            pool.failed(request, request.getException());
            this.processNextPendingRequest();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestTimeout(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(request);
            RouteSpecificPool<Object, C, E> pool = this.getPool(route);
            pool.timeout(request);
            this.processNextPendingRequest();
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getMax(T route) {
        Integer v = this.maxPerRoute.get(route);
        if (v != null) {
            return v;
        }
        return this.defaultMaxPerRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTotal(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.maxTotal = max;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxTotal() {
        this.lock.lock();
        try {
            int n = this.maxTotal;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultMaxPerRoute(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = max;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultMaxPerRoute() {
        this.lock.lock();
        try {
            int n = this.defaultMaxPerRoute;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPerRoute(T route, int max) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        if (max <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.maxPerRoute.put(route, max);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxPerRoute(T route) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        this.lock.lock();
        try {
            int n = this.getMax(route);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getStats(T route) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        this.lock.lock();
        try {
            RouteSpecificPool<T, C, E> pool = this.getPool(route);
            PoolStats poolStats = new PoolStats(pool.getLeasedCount(), pool.getPendingCount(), pool.getAvailableCount(), this.getMax(route));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdle(long idletime, TimeUnit tunit) {
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        long time = tunit.toMillis(idletime);
        if (time < 0L) {
            time = 0L;
        }
        long deadline = System.currentTimeMillis() - time;
        this.lock.lock();
        try {
            Iterator it = this.available.iterator();
            while (it.hasNext()) {
                PoolEntry entry = (PoolEntry)it.next();
                if (entry.getUpdated() > deadline) continue;
                entry.close();
                RouteSpecificPool<Object, C, PoolEntry> pool = this.getPool(entry.getRoute());
                pool.remove(entry);
                it.remove();
            }
            this.processPendingRequests();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeExpired() {
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            Iterator it = this.available.iterator();
            while (it.hasNext()) {
                PoolEntry entry = (PoolEntry)it.next();
                if (!entry.isExpired(now)) continue;
                entry.close();
                RouteSpecificPool<Object, C, PoolEntry> pool = this.getPool(entry.getRoute());
                pool.remove(entry);
                it.remove();
            }
            this.processPendingRequests();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[leased: ");
        buffer.append(this.leased);
        buffer.append("][available: ");
        buffer.append(this.available);
        buffer.append("][pending: ");
        buffer.append(this.pending);
        buffer.append("]");
        return buffer.toString();
    }

    class InternalSessionRequestCallback
    implements SessionRequestCallback {
        InternalSessionRequestCallback() {
        }

        public void completed(SessionRequest request) {
            AbstractNIOConnPool.this.requestCompleted(request);
        }

        public void cancelled(SessionRequest request) {
            AbstractNIOConnPool.this.requestCancelled(request);
        }

        public void failed(SessionRequest request) {
            AbstractNIOConnPool.this.requestFailed(request);
        }

        public void timeout(SessionRequest request) {
            AbstractNIOConnPool.this.requestTimeout(request);
        }
    }
}

