/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.annotation.Immutable;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParamConfig;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig config;

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull((Object)requestFactory, (String)"HTTP request factory");
        Args.notNull((Object)allocator, (String)"Byte buffer allocator");
        Args.notNull((Object)params, (String)"HTTP parameters");
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, requestFactory);
        this.allocator = allocator;
        this.config = HttpParamConfig.getConnectionConfig((HttpParams)params);
    }

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpParams params) {
        this((HttpRequestFactory)DefaultHttpRequestFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    public DefaultNHttpServerConnectionFactory(ByteBufferAllocator allocator, HttpRequestFactory requestFactory, ConnectionConfig config) {
        this.allocator = allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, requestFactory);
        this.config = config != null ? config : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpServerConnectionFactory(ConnectionConfig config) {
        this(null, null, config);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        CodingErrorAction unmappableInputAction;
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = this.config.getCharset();
        CodingErrorAction malformedInputAction = this.config.getMalformedInputAction() != null ? this.config.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = this.config.getUnmappableInputAction() != null ? this.config.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        return new DefaultNHttpServerConnection(session, 8192, this.allocator, chardecoder, charencoder, this.config.getMessageConstraints(), null, null, this.requestParserFactory, null);
    }
}

