/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.annotation.Immutable;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParamConfig;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SSLNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final ConnectionConfig config;

    @Deprecated
    public SSLNHttpServerConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull((Object)requestFactory, (String)"HTTP request factory");
        Args.notNull((Object)allocator, (String)"Byte buffer allocator");
        Args.notNull((Object)params, (String)"HTTP parameters");
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.allocator = allocator;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, requestFactory);
        this.config = HttpParamConfig.getConnectionConfig((HttpParams)params);
    }

    @Deprecated
    public SSLNHttpServerConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, (HttpRequestFactory)DefaultHttpRequestFactory.INSTANCE, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public SSLNHttpServerConnectionFactory(HttpParams params) {
        this(null, null, params);
    }

    public SSLNHttpServerConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpRequest> requestParserFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.allocator = allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE;
        this.requestParserFactory = requestParserFactory != null ? requestParserFactory : DefaultHttpRequestParserFactory.INSTANCE;
        this.config = config != null ? config : ConnectionConfig.DEFAULT;
    }

    public SSLNHttpServerConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslcontext, sslHandler, null, null, config);
    }

    public SSLNHttpServerConnectionFactory(ConnectionConfig config) {
        this(null, null, null, null, config);
    }

    private SSLContext getDefaultSSLContext() {
        SSLContext sslcontext;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failure initializing default SSL context", ex);
        }
        return sslcontext;
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    protected SSLIOSession createSSLIOSession(IOSession iosession, SSLContext sslcontext, SSLSetupHandler sslHandler) {
        SSLIOSession ssliosession = new SSLIOSession(iosession, SSLMode.SERVER, sslcontext != null ? sslcontext : this.getDefaultSSLContext(), sslHandler);
        iosession.setAttribute("http.session.ssl", ssliosession);
        return ssliosession;
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession iosession) {
        CodingErrorAction unmappableInputAction;
        SSLIOSession ssliosession = this.createSSLIOSession(iosession, this.sslcontext, this.sslHandler);
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = this.config.getCharset();
        CodingErrorAction malformedInputAction = this.config.getMalformedInputAction() != null ? this.config.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = this.config.getUnmappableInputAction() != null ? this.config.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        return new DefaultNHttpServerConnection(ssliosession, this.config.getBufferSize(), this.config.getFragmentSizeHint(), this.allocator, chardecoder, charencoder, this.config.getMessageConstraints(), null, null, this.requestParserFactory, null);
    }
}

