/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.protocol.Pipelined;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Pipelined
public class PipeliningClientExchangeHandler<T>
implements HttpAsyncClientExchangeHandler {
    private final Queue<HttpAsyncRequestProducer> requestProducerQueue;
    private final Queue<HttpAsyncResponseConsumer<T>> responseConsumerQueue;
    private final Queue<HttpRequest> requestQueue;
    private final Queue<T> resultQueue;
    private final BasicFuture<List<T>> future;
    private final HttpContext localContext;
    private final NHttpClientConnection conn;
    private final HttpProcessor httppocessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private volatile HttpAsyncRequestProducer requestProducer;
    private volatile HttpAsyncResponseConsumer<T> responseConsumer;
    private volatile boolean keepAlive;
    private volatile boolean done;

    public PipeliningClientExchangeHandler(List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, FutureCallback<List<T>> callback, HttpContext localContext, NHttpClientConnection conn, HttpProcessor httppocessor, ConnectionReuseStrategy connReuseStrategy) {
        Args.notEmpty(requestProducers, (String)"Request producer list");
        Args.notEmpty(responseConsumers, (String)"Response consumer list");
        Args.check((requestProducers.size() == responseConsumers.size() ? 1 : 0) != 0, (String)"Number of request producers does not match that of response consumers");
        this.requestProducerQueue = new ConcurrentLinkedQueue<HttpAsyncRequestProducer>(requestProducers);
        this.responseConsumerQueue = new ConcurrentLinkedQueue<HttpAsyncResponseConsumer<T>>(responseConsumers);
        this.requestQueue = new ConcurrentLinkedQueue<HttpRequest>();
        this.resultQueue = new ConcurrentLinkedQueue<T>();
        this.future = new BasicFuture(callback);
        this.localContext = (HttpContext)Args.notNull((Object)localContext, (String)"HTTP context");
        this.conn = (NHttpClientConnection)Args.notNull((Object)conn, (String)"HTTP connection");
        this.httppocessor = (HttpProcessor)Args.notNull((Object)httppocessor, (String)"HTTP processor");
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.localContext.setAttribute("http.connection", (Object)this.conn);
    }

    public PipeliningClientExchangeHandler(List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext localContext, NHttpClientConnection conn, HttpProcessor httppocessor) {
        this(requestProducers, responseConsumers, null, localContext, conn, httppocessor, null);
    }

    public Future<List<T>> getFuture() {
        return this.future;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void releaseResources() {
        PipeliningClientExchangeHandler.closeQuietly(this.requestProducer);
        this.requestProducer = null;
        PipeliningClientExchangeHandler.closeQuietly(this.responseConsumer);
        this.responseConsumer = null;
        while (!this.requestProducerQueue.isEmpty()) {
            PipeliningClientExchangeHandler.closeQuietly(this.requestProducerQueue.remove());
        }
        while (!this.responseConsumerQueue.isEmpty()) {
            PipeliningClientExchangeHandler.closeQuietly(this.responseConsumerQueue.remove());
        }
        this.requestQueue.clear();
        this.resultQueue.clear();
    }

    @Override
    public void close() throws IOException {
        this.releaseResources();
        if (!this.future.isDone()) {
            this.future.cancel();
        }
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        Asserts.check((this.requestProducer == null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is not null");
        this.requestProducer = this.requestProducerQueue.poll();
        if (this.requestProducer == null) {
            return null;
        }
        HttpRequest request = this.requestProducer.generateRequest();
        this.httppocessor.process(request, this.localContext);
        this.requestQueue.add(request);
        return request;
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        Asserts.check((this.requestProducer != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        this.requestProducer.produceContent(encoder, ioctrl);
    }

    @Override
    public void requestCompleted() {
        Asserts.check((this.requestProducer != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        this.requestProducer.requestCompleted(this.localContext);
        this.requestProducer = null;
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        Asserts.check((this.responseConsumer == null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is not null");
        this.responseConsumer = this.responseConsumerQueue.poll();
        Asserts.check((this.responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer queue is empty");
        HttpRequest request = this.requestQueue.poll();
        Asserts.check((request != null ? 1 : 0) != 0, (String)"Inconsistent state: request queue is empty");
        this.localContext.setAttribute("http.request", (Object)request);
        this.localContext.setAttribute("http.response", (Object)response);
        this.httppocessor.process(response, this.localContext);
        this.responseConsumer.responseReceived(response);
        this.keepAlive = this.connReuseStrategy.keepAlive(response, this.localContext);
    }

    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.check((this.responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        this.responseConsumer.consumeContent(decoder, ioctrl);
    }

    @Override
    public void responseCompleted() throws IOException {
        Asserts.check((this.responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        try {
            if (!this.keepAlive) {
                this.conn.close();
            }
            this.responseConsumer.responseCompleted(this.localContext);
            T result = this.responseConsumer.getResult();
            Exception ex = this.responseConsumer.getException();
            this.responseConsumer = null;
            if (result != null) {
                this.resultQueue.add(result);
            } else {
                this.future.failed(ex);
                this.conn.shutdown();
            }
            if (!this.conn.isOpen()) {
                this.done = true;
                this.releaseResources();
            }
            if (!this.future.isDone() && this.responseConsumerQueue.isEmpty()) {
                this.future.completed(new ArrayList<T>(this.resultQueue));
                this.resultQueue.clear();
            }
        }
        catch (RuntimeException ex) {
            this.failed(ex);
            throw ex;
        }
    }

    @Override
    public void inputTerminated() {
        this.failed((Exception)new ConnectionClosedException("Connection closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception ex) {
        this.done = true;
        try {
            if (this.requestProducer != null) {
                this.requestProducer.failed(ex);
            }
            if (this.responseConsumer != null) {
                this.responseConsumer.failed(ex);
            }
        }
        finally {
            try {
                this.future.failed(ex);
            }
            finally {
                this.releaseResources();
            }
        }
    }

    public boolean cancel() {
        this.done = true;
        try {
            boolean cancelled = this.responseConsumer.cancel();
            this.future.cancel();
            this.releaseResources();
            return cancelled;
        }
        catch (RuntimeException ex) {
            this.failed(ex);
            throw ex;
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

