/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.reactor.SSLIOSession;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.impl.nio.reactor.SSLMode;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;

public class SSLClientIOEventDispatch
implements IOEventDispatch {
    private static final String NHTTP_CONN = "NHTTP_CONN";
    private static final String SSL_SESSION = "SSL_SESSION";
    private final NHttpClientHandler handler;
    private final SSLContext sslcontext;
    private final SSLIOSessionHandler sslHandler;
    private final ByteBufferAllocator allocator;
    private final HttpParams params;

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, SSLIOSessionHandler sslHandler, ByteBufferAllocator allocator, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (sslcontext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("ByteBuffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = handler;
        this.params = params;
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.allocator = allocator;
    }

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, (ByteBufferAllocator)new HeapByteBufferAllocator(), params);
    }

    public void connected(IOSession session) {
        SSLIOSession sslSession = new SSLIOSession(session, this.sslcontext, this.sslHandler);
        DefaultNHttpClientConnection conn = new DefaultNHttpClientConnection((IOSession)sslSession, (HttpResponseFactory)new DefaultHttpResponseFactory(), this.allocator, this.params);
        session.setAttribute(NHTTP_CONN, (Object)conn);
        session.setAttribute(SSL_SESSION, (Object)sslSession);
        Object attachment = session.getAttribute("http.session.attachment");
        this.handler.connected((NHttpClientConnection)conn, attachment);
        try {
            sslSession.bind(SSLMode.CLIENT, this.params);
        }
        catch (SSLException ex) {
            this.handler.exception((NHttpClientConnection)conn, (IOException)ex);
            sslSession.shutdown();
        }
    }

    public void disconnected(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        this.handler.closed((NHttpClientConnection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputReady(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        try {
            SSLIOSession sSLIOSession = sslSession;
            synchronized (sSLIOSession) {
                if (sslSession.isAppInputReady()) {
                    conn.consumeInput(this.handler);
                }
                sslSession.inboundTransport();
            }
        }
        catch (IOException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputReady(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        try {
            SSLIOSession sSLIOSession = sslSession;
            synchronized (sSLIOSession) {
                if (sslSession.isAppOutputReady()) {
                    conn.produceOutput(this.handler);
                }
                sslSession.outboundTransport();
            }
        }
        catch (IOException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.handler.timeout((NHttpClientConnection)conn);
        SSLIOSession sSLIOSession = sslSession;
        synchronized (sSLIOSession) {
            if (sslSession.isOutboundDone() && !sslSession.isInboundDone()) {
                sslSession.shutdown();
            }
        }
    }
}

