/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.http.HttpInetConnection;
import org.apache.http.impl.AbstractHttpClientConnection;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.io.SocketHttpDataReceiver;
import org.apache.http.impl.io.SocketHttpDataTransmitter;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SocketHttpClientConnection
extends AbstractHttpClientConnection
implements HttpInetConnection {
    protected volatile boolean open;
    protected Socket socket = null;

    protected void assertNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Connection is already open");
        }
    }

    protected void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    protected void bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        this.socket = socket;
        int buffersize = HttpConnectionParams.getSocketBufferSize(params);
        SocketHttpDataTransmitter transmitter = new SocketHttpDataTransmitter(socket, buffersize);
        SocketHttpDataReceiver receiver = new SocketHttpDataReceiver(socket, buffersize);
        transmitter.reset(params);
        receiver.reset(params);
        this.setHttpDataReceiver(receiver);
        this.setHttpDataTransmitter(transmitter);
        this.setMaxHeaderCount(params.getIntParameter("http.connection.max-header-count", -1));
        this.setResponseFactory(new DefaultHttpResponseFactory());
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public InetAddress getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return null;
    }

    public InetAddress getRemoteAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    public void shutdown() throws IOException {
        this.open = false;
        Socket tmpsocket = this.socket;
        if (tmpsocket != null) {
            tmpsocket.close();
        }
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.doFlush();
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }
}

