/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class BasicHttpProcessor
implements HttpProcessor {
    private List requestInterceptors = null;
    private List responseInterceptors = null;

    public void addInterceptor(HttpRequestInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new ArrayList();
        }
        this.requestInterceptors.add(interceptor);
    }

    public void removeInterceptor(HttpRequestInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (this.requestInterceptors == null) {
            return;
        }
        this.requestInterceptors.remove(interceptor);
        if (this.requestInterceptors.isEmpty()) {
            this.requestInterceptors = null;
        }
    }

    public void addInterceptor(HttpResponseInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new ArrayList();
        }
        this.responseInterceptors.add(interceptor);
    }

    public void removeInterceptor(HttpResponseInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (this.responseInterceptors == null) {
            return;
        }
        this.responseInterceptors.remove(interceptor);
        if (this.responseInterceptors.isEmpty()) {
            this.responseInterceptors = null;
        }
    }

    public void removeInterceptors(Class clazz) {
        Iterator i;
        if (clazz == null) {
            return;
        }
        if (this.requestInterceptors != null) {
            i = this.requestInterceptors.iterator();
            while (i.hasNext()) {
                if (!clazz.isInstance(i.next())) continue;
                i.remove();
            }
        }
        if (this.responseInterceptors != null) {
            i = this.responseInterceptors.iterator();
            while (i.hasNext()) {
                if (!clazz.isInstance(i.next())) continue;
                i.remove();
            }
        }
    }

    public void setInterceptors(List list) {
        if (list == null) {
            return;
        }
        if (this.requestInterceptors != null) {
            this.requestInterceptors.clear();
        }
        if (this.responseInterceptors != null) {
            this.responseInterceptors.clear();
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof HttpRequestInterceptor) {
                this.addInterceptor((HttpRequestInterceptor)obj);
            }
            if (!(obj instanceof HttpResponseInterceptor)) continue;
            this.addInterceptor((HttpResponseInterceptor)obj);
        }
    }

    public void clearInterceptors() {
        this.requestInterceptors = null;
        this.responseInterceptors = null;
    }

    public void process(HttpRequest request, HttpContext context) throws IOException, HttpException {
        if (this.requestInterceptors != null) {
            for (int i = 0; i < this.requestInterceptors.size(); ++i) {
                HttpRequestInterceptor interceptor = (HttpRequestInterceptor)this.requestInterceptors.get(i);
                interceptor.process(request, context);
            }
        }
    }

    public void process(HttpResponse response, HttpContext context) throws IOException, HttpException {
        if (this.responseInterceptors != null) {
            for (int i = 0; i < this.responseInterceptors.size(); ++i) {
                HttpResponseInterceptor interceptor = (HttpResponseInterceptor)this.responseInterceptors.get(i);
                interceptor.process(response, context);
            }
        }
    }
}

