/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.http.params.HttpParams;

public class BasicHttpParams
implements HttpParams,
Serializable {
    static final long serialVersionUID = -8296449161405728403L;
    private HttpParams defaults = null;
    private HashMap parameters = null;

    public BasicHttpParams(HttpParams defaults) {
        this.defaults = defaults;
    }

    public BasicHttpParams() {
        this(null);
    }

    public synchronized HttpParams getDefaults() {
        return this.defaults;
    }

    public synchronized void setDefaults(HttpParams params) {
        this.defaults = params;
    }

    public synchronized Object getParameter(String name) {
        Object param = null;
        if (this.parameters != null) {
            param = this.parameters.get(name);
        }
        if (param != null) {
            return param;
        }
        if (this.defaults != null) {
            return this.defaults.getParameter(name);
        }
        return null;
    }

    public synchronized HttpParams setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
        return this;
    }

    public synchronized void setParameters(String[] names, Object value) {
        for (int i = 0; i < names.length; ++i) {
            this.setParameter(names[i], value);
        }
    }

    public long getLongParameter(String name, long defaultValue) {
        Object param = this.getParameter(name);
        if (param == null) {
            return defaultValue;
        }
        return (Long)param;
    }

    public HttpParams setLongParameter(String name, long value) {
        this.setParameter(name, new Long(value));
        return this;
    }

    public int getIntParameter(String name, int defaultValue) {
        Object param = this.getParameter(name);
        if (param == null) {
            return defaultValue;
        }
        return (Integer)param;
    }

    public HttpParams setIntParameter(String name, int value) {
        this.setParameter(name, new Integer(value));
        return this;
    }

    public double getDoubleParameter(String name, double defaultValue) {
        Object param = this.getParameter(name);
        if (param == null) {
            return defaultValue;
        }
        return (Double)param;
    }

    public HttpParams setDoubleParameter(String name, double value) {
        this.setParameter(name, new Double(value));
        return this;
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        Object param = this.getParameter(name);
        if (param == null) {
            return defaultValue;
        }
        return (Boolean)param;
    }

    public HttpParams setBooleanParameter(String name, boolean value) {
        this.setParameter(name, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public boolean isParameterSet(String name) {
        return this.getParameter(name) != null;
    }

    public synchronized boolean isParameterSetLocally(String name) {
        return this.parameters != null && this.parameters.get(name) != null;
    }

    public boolean isParameterTrue(String name) {
        return this.getBooleanParameter(name, false);
    }

    public boolean isParameterFalse(String name) {
        return !this.getBooleanParameter(name, false);
    }

    public synchronized void clear() {
        this.parameters = null;
    }
}

