/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.nio.impl.codecs.AbstractContentDecoder;
import org.apache.http.nio.impl.reactor.SessionInputBuffer;

public class IdentityDecoder
extends AbstractContentDecoder {
    public IdentityDecoder(ReadableByteChannel channel, SessionInputBuffer buffer) {
        super(channel, buffer);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (dst == null) {
            throw new IllegalArgumentException("Byte buffer may not be null");
        }
        if (this.completed) {
            return -1;
        }
        int bytesRead = this.buffer.hasData() ? this.buffer.read(dst) : this.channel.read(dst);
        if (bytesRead == -1) {
            this.completed = true;
        }
        return bytesRead;
    }
}

