/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.nio.impl.codecs.AbstractContentDecoder;
import org.apache.http.nio.impl.reactor.SessionInputBuffer;

public class LengthDelimitedDecoder
extends AbstractContentDecoder {
    private final long contentLength;
    private long len;

    public LengthDelimitedDecoder(ReadableByteChannel channel, SessionInputBuffer buffer, long contentLength) {
        super(channel, buffer);
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length may not be negative");
        }
        this.contentLength = contentLength;
    }

    public int read(ByteBuffer dst) throws IOException {
        int bytesRead;
        if (dst == null) {
            throw new IllegalArgumentException("Byte buffer may not be null");
        }
        if (this.completed) {
            return -1;
        }
        int lenRemaining = (int)(this.contentLength - this.len);
        if (this.buffer.hasData()) {
            int maxLen = Math.min(lenRemaining, this.buffer.length());
            bytesRead = this.buffer.read(dst, maxLen);
        } else if (dst.remaining() > lenRemaining) {
            int oldLimit = dst.limit();
            int newLimit = oldLimit - (dst.remaining() - lenRemaining);
            dst.limit(newLimit);
            bytesRead = this.channel.read(dst);
            dst.limit(oldLimit);
        } else {
            bytesRead = this.channel.read(dst);
        }
        this.len += (long)bytesRead;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        return bytesRead;
    }
}

