/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.http.nio.impl.reactor.BaseIOReactor;
import org.apache.http.nio.impl.reactor.ChannelEntry;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;

public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    private final int workerCount;
    private final BaseIOReactor[] ioReactors;
    private final WorkerThread[] threads;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(long selectTimeout, int workerCount) throws IOException {
        if (workerCount <= 0) {
            throw new IllegalArgumentException("Worker count may not be negative or zero");
        }
        this.workerCount = workerCount;
        this.ioReactors = new BaseIOReactor[workerCount];
        this.threads = new WorkerThread[workerCount];
        for (int i = 0; i < this.ioReactors.length; ++i) {
            this.ioReactors[i] = new BaseIOReactor(selectTimeout);
        }
    }

    protected void startWorkers(IOEventDispatch eventDispatch) {
        int i;
        for (i = 0; i < this.workerCount; ++i) {
            BaseIOReactor ioReactor = this.ioReactors[i];
            this.threads[i] = new WorkerThread(ioReactor, eventDispatch);
        }
        for (i = 0; i < this.workerCount; ++i) {
            this.threads[i].start();
        }
    }

    protected void stopWorkers(int millis) throws IOException {
        int i;
        for (i = 0; i < this.workerCount; ++i) {
            this.ioReactors[i].shutdown();
        }
        for (i = 0; i < this.workerCount; ++i) {
            try {
                this.threads[i].join(millis);
                continue;
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException(ex.getMessage());
            }
        }
    }

    protected void verifyWorkers() throws IOException {
        for (int i = 0; i < this.workerCount; ++i) {
            IOException ex;
            WorkerThread worker = this.threads[i];
            if (worker.isAlive() || (ex = worker.getException()) == null) continue;
            throw ex;
        }
    }

    protected void addChannel(ChannelEntry entry) throws IOException {
        this.ioReactors[this.currentWorker++ % this.workerCount].addChannel(entry);
    }

    static class WorkerThread
    extends Thread {
        final BaseIOReactor ioReactor;
        final IOEventDispatch eventDispatch;
        private volatile IOException exception;

        public WorkerThread(BaseIOReactor ioReactor, IOEventDispatch eventDispatch) {
            this.ioReactor = ioReactor;
            this.eventDispatch = eventDispatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.ioReactor.execute(this.eventDispatch);
            }
            catch (IOException ex) {
                this.exception = ex;
            }
            finally {
                try {
                    this.ioReactor.shutdown();
                }
                catch (IOException ex2) {
                    this.exception = ex2;
                }
            }
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

