/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.reactor;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.nio.impl.reactor.AbstractIOReactor;
import org.apache.http.nio.impl.reactor.SessionHandle;
import org.apache.http.nio.impl.reactor.SessionSet;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;

public class BaseIOReactor
extends AbstractIOReactor {
    private final long timeoutCheckInterval;
    private SessionSet bufferingSessions = new SessionSet();
    private long lastTimeoutCheck;

    public BaseIOReactor(long selectTimeout) throws IOException {
        super(selectTimeout);
        this.timeoutCheckInterval = selectTimeout;
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    protected void acceptable(SelectionKey key) {
    }

    protected void connectable(SelectionKey key) {
    }

    protected void readable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastRead();
        this.eventDispatch.inputReady(session);
        SessionBufferStatus bufStatus = session.getBufferStatus();
        if (bufStatus != null && bufStatus.hasBufferedInput()) {
            this.bufferingSessions.add(session);
        }
    }

    protected void writable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastWrite();
        this.eventDispatch.outputReady(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(Set keys) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.timeoutCheckInterval) {
            this.lastTimeoutCheck = currentTime;
            if (keys != null) {
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = (SelectionKey)it.next();
                    this.timeoutCheck(key, currentTime);
                }
            }
        }
        SessionSet sessionSet = this.bufferingSessions;
        synchronized (sessionSet) {
            if (!this.bufferingSessions.isEmpty()) {
                Iterator it = this.bufferingSessions.iterator();
                while (it.hasNext()) {
                    IOSession session = (IOSession)it.next();
                    SessionBufferStatus bufStatus = session.getBufferStatus();
                    if (bufStatus != null && !bufStatus.hasBufferedInput()) {
                        it.remove();
                        continue;
                    }
                    int ops = session.getEventMask();
                    if ((ops & 1) <= 0) continue;
                    this.eventDispatch.inputReady(session);
                    if (bufStatus == null || bufStatus.hasBufferedInput()) continue;
                    it.remove();
                }
            }
        }
    }

    protected void timeoutCheck(SelectionKey key, long now) {
        SessionHandle handle;
        IOSession session;
        int timeout;
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle && (timeout = (session = (handle = (SessionHandle)key.attachment()).getSession()).getSocketTimeout()) > 0 && handle.getLastReadTime() + (long)timeout < now) {
            this.eventDispatch.timeout(session);
        }
    }

    protected void keyCreated(SelectionKey key, IOSession session) {
        SessionHandle handle = new SessionHandle(session);
        key.attach(handle);
    }

    protected IOSession keyCancelled(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle) {
            SessionHandle handle = (SessionHandle)attachment;
            return handle.getSession();
        }
        return null;
    }
}

