/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.reactor;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.nio.impl.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.nio.impl.reactor.ChannelEntry;
import org.apache.http.nio.impl.reactor.SessionRequestHandle;
import org.apache.http.nio.impl.reactor.SessionRequestImpl;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    public static int TIMEOUT_CHECK_INTERVAL = 1000;
    private volatile boolean closed = false;
    private final HttpParams params;
    private final Selector selector;
    private long lastTimeoutCheck;

    public DefaultConnectingIOReactor(int workerCount, HttpParams params) throws IOException {
        super(TIMEOUT_CHECK_INTERVAL, workerCount);
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params;
        this.selector = Selector.open();
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    public void execute(IOEventDispatch eventDispatch) throws IOException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.startWorkers(eventDispatch);
        while (true) {
            long currentTime;
            int readyCount = this.selector.select(TIMEOUT_CHECK_INTERVAL);
            if (this.closed) break;
            if (readyCount > 0) {
                this.processEvents(this.selector.selectedKeys());
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastTimeoutCheck >= (long)TIMEOUT_CHECK_INTERVAL) {
                this.lastTimeoutCheck = currentTime;
                Set<SelectionKey> keys = this.selector.keys();
                if (keys != null) {
                    this.processTimeouts(keys);
                }
            }
            this.verifyWorkers();
        }
    }

    private void processEvents(Set selectedKeys) throws IOException {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    private void processEvent(SelectionKey key) throws IOException {
        block5: {
            try {
                if (!key.isConnectable()) break block5;
                SocketChannel channel = (SocketChannel)key.channel();
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                SessionRequestImpl sessionRequest = requestHandle.getSessionRequest();
                try {
                    channel.finishConnect();
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
                key.cancel();
                if (channel.isConnected()) {
                    this.prepareSocket(channel.socket());
                    Object attachment = sessionRequest.getAttachment();
                    ChannelEntry entry = new ChannelEntry(channel, attachment);
                    this.addChannel(entry);
                }
            }
            catch (CancelledKeyException ex) {
                key.attach(null);
            }
        }
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        int linger = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    private void processTimeouts(Set keys) {
        long now = System.currentTimeMillis();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SessionRequestHandle handle;
            SessionRequestImpl sessionRequest;
            int timeout;
            SelectionKey key = (SelectionKey)it.next();
            Object attachment = key.attachment();
            if (!(attachment instanceof SessionRequestHandle) || (timeout = (sessionRequest = (handle = (SessionRequestHandle)key.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || handle.getRequestTime() + (long)timeout >= now) continue;
            sessionRequest.timeout();
        }
    }

    public SessionRequest connect(SocketAddress remoteAddress, SocketAddress localAddress, Object attachment) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        if (localAddress != null) {
            socketChannel.socket().bind(localAddress);
        }
        socketChannel.connect(remoteAddress);
        SelectionKey key = socketChannel.register(this.selector, 8);
        SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteAddress, localAddress, attachment, key);
        sessionRequest.setConnectTimeout(HttpConnectionParams.getConnectionTimeout((HttpParams)this.params));
        SessionRequestHandle requestHandle = new SessionRequestHandle(sessionRequest);
        key.attach(requestHandle);
        return sessionRequest;
    }

    public void shutdown() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.selector.close();
        this.stopWorkers(500);
    }
}

