/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.reactor;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.nio.impl.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.nio.impl.reactor.ChannelEntry;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class DefaultListeningIOReactor
extends AbstractMultiworkerIOReactor
implements ListeningIOReactor {
    public static int TIMEOUT_CHECK_INTERVAL = 1000;
    private volatile boolean closed = false;
    private final HttpParams params;
    private final Selector selector;

    public DefaultListeningIOReactor(int workerCount, HttpParams params) throws IOException {
        super(TIMEOUT_CHECK_INTERVAL, workerCount);
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params;
        this.selector = Selector.open();
    }

    public void execute(IOEventDispatch eventDispatch) throws IOException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.startWorkers(eventDispatch);
        while (true) {
            int readyCount = this.selector.select(TIMEOUT_CHECK_INTERVAL);
            if (this.closed) break;
            if (readyCount > 0) {
                this.processEvents(this.selector.selectedKeys());
            }
            this.verifyWorkers();
        }
    }

    private void processEvents(Set selectedKeys) throws IOException {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    private void processEvent(SelectionKey key) throws IOException {
        try {
            ServerSocketChannel serverChannel;
            SocketChannel socketChannel;
            if (key.isAcceptable() && (socketChannel = (serverChannel = (ServerSocketChannel)key.channel()).accept()) != null) {
                this.prepareSocket(socketChannel.socket());
                ChannelEntry entry = new ChannelEntry(socketChannel);
                this.addChannel(entry);
            }
        }
        catch (CancelledKeyException ex) {
            key.attach(null);
        }
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        int linger = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    public void listen(SocketAddress address) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(address);
        SelectionKey key = serverChannel.register(this.selector, 16);
        key.attach(null);
    }

    public void shutdown() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.selector.close();
        this.stopWorkers(500);
    }
}

