/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.impl.reactor;

import org.apache.http.nio.reactor.IOSession;

public class SessionHandle {
    private final IOSession session;
    private final long startedTime;
    private long lastReadTime;
    private long lastWriteTime;

    public SessionHandle(IOSession session) {
        long now;
        if (session == null) {
            throw new IllegalArgumentException("Session may not be null");
        }
        this.session = session;
        this.startedTime = now = System.currentTimeMillis();
        this.lastReadTime = now;
        this.lastWriteTime = now;
    }

    public IOSession getSession() {
        return this.session;
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public void resetLastRead() {
        this.lastReadTime = System.currentTimeMillis();
    }

    public void resetLastWrite() {
        this.lastWriteTime = System.currentTimeMillis();
    }
}

