/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;

public class AsyncHttpService {
    private final ContentInputBuffer inbuffer;
    private final ContentOutputBuffer outbuffer;
    private HttpParams params = null;
    private HttpResponseFactory responseFactory = null;
    private HttpProcessor httpProcessor = null;
    private HttpRequestHandlerResolver handlerResolver = null;
    private ConnectionReuseStrategy connStrategy = null;

    public AsyncHttpService(ContentInputBuffer inbuffer, ContentOutputBuffer outbuffer, HttpProcessor proc, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory) {
        if (inbuffer == null) {
            throw new IllegalArgumentException("Content input buffer may not be null");
        }
        if (outbuffer == null) {
            throw new IllegalArgumentException("Content output buffer may not be null");
        }
        this.inbuffer = inbuffer;
        this.outbuffer = outbuffer;
        this.setHttpProcessor(proc);
        this.setConnReuseStrategy(connStrategy);
        this.setResponseFactory(responseFactory);
    }

    public void setHttpProcessor(HttpProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        this.httpProcessor = processor;
    }

    public void setConnReuseStrategy(ConnectionReuseStrategy connStrategy) {
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        this.connStrategy = connStrategy;
    }

    public void setResponseFactory(HttpResponseFactory responseFactory) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
    }

    public void setHandlerResolver(HttpRequestHandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    public void shutdown() {
        this.inbuffer.shutdown();
        this.outbuffer.shutdown();
    }

    public void shutdown(IOException ex) {
        this.inbuffer.shutdown(ex);
        this.outbuffer.shutdown(ex);
    }

    public void handleRequest(HttpRequest request, NHttpServerConnection conn) throws HttpException, IOException {
        HttpContext parentContext = conn.getContext();
        HttpVersion ver = request.getRequestLine().getHttpVersion();
        if (!ver.lessEquals(HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityReq = (HttpEntityEnclosingRequest)request;
            if (entityReq.expectContinue()) {
                HttpResponse ack = this.responseFactory.newHttpResponse(ver, 100);
                conn.submitResponse(ack);
            }
            HttpEntity entity = entityReq.getEntity();
            BasicHttpEntity newEntity = new BasicHttpEntity();
            ContentInputStream instream = new ContentInputStream(this.inbuffer);
            newEntity.setContent((InputStream)instream);
            newEntity.setChunked(entity.isChunked());
            newEntity.setContentLength(entity.getContentLength());
            newEntity.setContentType(entity.getContentType());
            newEntity.setContentEncoding(entity.getContentEncoding());
            entityReq.setEntity((HttpEntity)newEntity);
        }
        request.getParams().setDefaults(this.params);
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 200);
        response.getParams().setDefaults(this.params);
        HttpExecutionContext context = new HttpExecutionContext(parentContext);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("http.response", (Object)response);
        try {
            this.httpProcessor.process(request, (HttpContext)context);
            this.doService(request, response, (HttpContext)context);
            this.httpProcessor.process(response, (HttpContext)context);
        }
        catch (HttpException ex) {
            this.handleException(conn, ex);
            return;
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityReq = (HttpEntityEnclosingRequest)request;
            HttpEntity entity = entityReq.getEntity();
            entity.consumeContent();
        }
        conn.submitResponse(response);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ContentOutputStream outstream = new ContentOutputStream(this.outbuffer);
            entity.writeTo((OutputStream)outstream);
            outstream.flush();
        }
        if (this.connStrategy.keepAlive(response, (HttpContext)context)) {
            this.inbuffer.reset();
            this.outbuffer.reset();
        } else {
            conn.close();
        }
    }

    public void handleException(NHttpServerConnection conn, HttpException ex) throws HttpException, IOException {
        HttpContext context = conn.getContext();
        HttpResponse response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 200);
        response.getParams().setDefaults(this.params);
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        StringEntity entity = new StringEntity(ex.getMessage(), "US-ASCII");
        entity.setContentEncoding("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
        this.httpProcessor.process(response, context);
        conn.submitResponse(response);
        ContentOutputStream outstream = new ContentOutputStream(this.outbuffer);
        entity.writeTo((OutputStream)outstream);
        outstream.flush();
        if (this.connStrategy.keepAlive(response, context)) {
            this.inbuffer.reset();
            this.outbuffer.reset();
        } else {
            conn.close();
        }
    }

    public void consumeContent(ContentDecoder decoder) throws IOException {
        this.inbuffer.consumeContent(decoder);
    }

    public void produceContent(ContentEncoder encoder) throws IOException {
        this.outbuffer.produceContent(encoder);
    }

    protected void doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequestHandler handler = null;
        if (this.handlerResolver != null) {
            String requestURI = request.getRequestLine().getUri();
            handler = this.handlerResolver.lookup(requestURI);
        }
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setStatusCode(501);
        }
    }

    private static class ContentOutputStream
    extends OutputStream {
        private final ContentOutputBuffer buffer;

        public ContentOutputStream(ContentOutputBuffer buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException("Output buffer may not be null");
            }
            this.buffer = buffer;
        }

        public void close() throws IOException {
            this.buffer.flush();
            this.buffer.shutdown();
        }

        public void flush() throws IOException {
            this.buffer.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.buffer.write(b);
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
        }
    }

    private static class ContentInputStream
    extends InputStream {
        private final ContentInputBuffer buffer;

        public ContentInputStream(ContentInputBuffer buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException("Input buffer may not be null");
            }
            this.buffer = buffer;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.buffer.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.buffer.read(b);
        }

        public int read() throws IOException {
            return this.buffer.read();
        }
    }
}

